/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.ownable;

import com.github.elenterius.biomancy.block.property.UserSensitivity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.util.ownable.Ownable;
import com.github.elenterius.biomancy.util.ownable.OwnableEntityBlock;
import com.github.elenterius.biomancy.util.permission.Actions;
import com.github.elenterius.biomancy.util.permission.IRestrictedInteraction;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OwnableTrapDoorBlock
extends TrapDoorBlock
implements OwnableEntityBlock {
    public static final EnumProperty<UserSensitivity> SENSITIVITY = ModBlockProperties.USER_SENSITIVITY;
    protected static final AABB TOP_AABB_VOLUME = new AABB(0.0, 0.75, 0.0, 1.0, 1.25, 1.0);
    protected static final AABB BOTTOM_AABB_VOLUME = new AABB(0.0, -0.25, 0.0, 1.0, 0.25, 1.0);
    protected static final AABB INFLATED_AABB_VOLUME = new AABB(-0.125, -0.25, -0.125, 1.125, 1.25, 1.125);
    protected static final VoxelShape BOTTOM_COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public OwnableTrapDoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(properties, type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SENSITIVITY, (Comparable)((Object)UserSensitivity.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SENSITIVITY});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.OWNABLE_BE.get()).m_155264_(pos, state);
    }

    public boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_57516_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!this.isOpen(state) && state.m_61143_((Property)f_57515_) == Half.BOTTOM) {
            return this.f_60443_ ? BOTTOM_COLLISION_SHAPE : Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IRestrictedInteraction restrictedBlock;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (restrictedBlock = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.USE_BLOCK)) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (item instanceof EssenceItem) {
                EssenceItem essenceItem = (EssenceItem)item;
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (restrictedBlock.isActionAllowed(player, Actions.CONFIGURE)) {
                    boolean success = essenceItem.getEntityUUID(stack).map(restrictedBlock::addUser).orElse(false);
                    if (success) {
                        stack.m_41774_(1);
                        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                        return InteractionResult.SUCCESS;
                    }
                }
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                return InteractionResult.CONSUME;
            }
            if (player.m_6144_()) {
                state = (BlockState)state.m_61122_(SENSITIVITY);
                level.m_7731_(pos, state, 2);
                if (this.isWaterlogged(state)) {
                    level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            state = (BlockState)state.m_61122_((Property)f_57514_);
            level.m_7731_(pos, state, 2);
            if (this.isWaterlogged(state)) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            this.m_57527_(player, level, pos, this.isOpen(state));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return InteractionResult.PASS;
    }

    protected void m_57527_(@Nullable Player player, Level level, BlockPos pos, boolean isOpened) {
        level.m_5594_(player, pos, isOpened ? this.f_271458_.f_271258_() : this.f_271458_.f_271425_(), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction) {
            Ownable neighbor;
            Optional<UUID> neighborOwner;
            BlockEntity blockEntity2;
            IRestrictedInteraction restricted = (IRestrictedInteraction)blockEntity;
            boolean isAllowed = false;
            if (neighborBlock instanceof OwnableEntityBlock && level.m_8055_(neighborPos).m_60713_(neighborBlock) && (blockEntity2 = level.m_7702_(neighborPos)) instanceof Ownable && (neighborOwner = (neighbor = (Ownable)blockEntity2).getOptionalOwnerUUID()).isPresent()) {
                isAllowed = restricted.isActionAllowed(neighborOwner.get(), Actions.USE_BLOCK);
            }
            boolean hasSignal = level.m_276867_(pos);
            boolean isPowered = this.isPowered(state);
            if (isAllowed) {
                this.handleAllowedSignal(state, level, pos, hasSignal, isPowered);
                return;
            }
            this.handleForbiddenSignal(state, level, pos, hasSignal, isPowered);
        }
    }

    private void handleForbiddenSignal(BlockState state, Level level, BlockPos pos, boolean hasSignal, boolean isPowered) {
        if (hasSignal == isPowered) {
            return;
        }
        if (this.isOpen(state)) {
            this.m_57527_(null, level, pos, false);
            state = (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false));
            level.m_142346_(null, GameEvent.f_157793_, pos);
        } else if (hasSignal) {
            level.m_5594_(null, pos, SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(hasSignal)), 2);
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    private void handleAllowedSignal(BlockState state, Level level, BlockPos pos, boolean hasSignal, boolean isPowered) {
        if (hasSignal == isPowered) {
            return;
        }
        if (hasSignal != this.isOpen(state)) {
            this.m_57527_(null, level, pos, hasSignal);
            state = (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(hasSignal));
            level.m_142346_(null, hasSignal ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(hasSignal)), 2);
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity;
        if (!this.isOpen(state)) {
            return;
        }
        UserSensitivity sensitivity = (UserSensitivity)((Object)state.m_61143_(SENSITIVITY));
        if (!sensitivity.isNone() && (blockEntity = level.m_7702_(pos)) instanceof IRestrictedInteraction) {
            IRestrictedInteraction restricted = (IRestrictedInteraction)blockEntity;
            AABB aabb = INFLATED_AABB_VOLUME.m_82338_(pos);
            List list = level.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity livingEntity : list) {
                if (livingEntity.m_20161_()) continue;
                boolean actionAllowed = restricted.isActionAllowed((Entity)livingEntity, Actions.USE_BLOCK);
                if (sensitivity == UserSensitivity.HOSTILE) {
                    if (actionAllowed) continue;
                    level.m_186460_(pos, state.m_60734_(), 60);
                    return;
                }
                if (!actionAllowed) continue;
                level.m_186460_(pos, state.m_60734_(), 60);
                return;
            }
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false)), 2);
        level.m_5594_(null, pos, SoundEvents.f_12628_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_(null, GameEvent.f_157793_, pos);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return false;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        this.openDoorOnEntityCollision(state, level, pos, entity);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.openDoorOnEntityCollision(state, level, pos, entity);
    }

    protected void openDoorOnEntityCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return;
        }
        if (this.isOpen(state) || !(entity instanceof LivingEntity)) {
            return;
        }
        UserSensitivity sensitivity = (UserSensitivity)((Object)state.m_61143_(SENSITIVITY));
        if (!sensitivity.isNone() && (blockEntity = level.m_7702_(pos)) instanceof IRestrictedInteraction) {
            IRestrictedInteraction restricted = (IRestrictedInteraction)blockEntity;
            AABB aabb = state.m_61143_((Property)f_57515_) == Half.TOP ? TOP_AABB_VOLUME.m_82338_(pos) : BOTTOM_AABB_VOLUME.m_82338_(pos);
            List list = level.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity livingEntity : list) {
                if (livingEntity.m_20161_()) continue;
                boolean actionAllowed = restricted.isActionAllowed((Entity)livingEntity, Actions.USE_BLOCK);
                if (sensitivity == UserSensitivity.HOSTILE) {
                    if (actionAllowed) continue;
                    this.openTrapDoor(level, state, pos, true);
                    return;
                }
                if (!actionAllowed) continue;
                this.openTrapDoor(level, state, pos, true);
                return;
            }
        }
    }

    public void openTrapDoor(Level level, BlockState state, BlockPos pos, boolean autoClose) {
        if (level.m_5776_()) {
            return;
        }
        if (this.isOpen(state)) {
            return;
        }
        state = (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(true));
        level.m_7731_(pos, state, 2);
        level.m_142346_(null, GameEvent.f_157796_, pos);
        if (autoClose) {
            level.m_186460_(pos, state.m_60734_(), 40);
        }
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        level.m_5594_(null, pos, SoundEvents.f_12629_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isWaterlogged(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_57517_);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_57514_);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        OwnableEntityBlock.appendUserListToTooltip(stack, tooltip);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Ownable) {
            Ownable ownable = (Ownable)blockEntity;
            OwnableEntityBlock.setBlockEntityOwner(level, ownable, placer, stack);
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        IRestrictedInteraction interaction;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (interaction = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.DESTROY_BLOCK)) {
            return super.m_5880_(state, player, level, pos);
        }
        return 0.0f;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }
}

