/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.property;

import com.github.elenterius.biomancy.mixin.accessor.IntegerPropertyAccessor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockPropertyUtil {
    public static final String AGE_PROPERTY = "age";

    private BlockPropertyUtil() {
    }

    public static int getMaxValue(IntegerProperty property) {
        return ((IntegerPropertyAccessor)property).biomancy$getMax();
    }

    public static int getMinValue(IntegerProperty property) {
        return ((IntegerPropertyAccessor)property).biomancy$getMin();
    }

    public static Optional<IntegerProperty> getAgeProperty(BlockState state) {
        for (Property prop : state.m_61147_()) {
            if (!prop.m_61708_().equals(AGE_PROPERTY) || !(prop instanceof IntegerProperty)) continue;
            IntegerProperty intProperty = (IntegerProperty)prop;
            return Optional.of(intProperty);
        }
        return Optional.empty();
    }

    public static int getAge(BlockState state) {
        return BlockPropertyUtil.getAgeProperty(state).map(arg_0 -> ((BlockState)state).m_61143_(arg_0)).orElse(0);
    }

    public static <T extends Comparable<T>> T getPrevious(Property<T> property, T value) {
        return BlockPropertyUtil.findPrevious(property.m_6908_(), value);
    }

    private static <T> T findPrevious(Collection<T> collection, T value) {
        Iterator<T> iterator = collection.iterator();
        T previous = null;
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (next.equals(value) && previous != null) {
                return previous;
            }
            previous = next;
        }
        return previous != null ? previous : (T)value;
    }

    public static <T extends Comparable<T>> T getLast(Property<T> property) {
        return (T)((Comparable)BlockPropertyUtil.findLast(property.m_6908_()));
    }

    private static <T> T findLast(Collection<T> collection) {
        T value = collection.iterator().next();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t;
            value = t = iterator.next();
        }
        return value;
    }
}

