/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.property;

import com.mojang.math.OctahedralGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public enum DirectionalSlabType implements StringRepresentable
{
    HALF_NORTH("half_north", Direction.NORTH),
    HALF_SOUTH("half_south", Direction.SOUTH),
    HALF_WEST("half_west", Direction.WEST),
    HALF_EAST("half_east", Direction.EAST),
    HALF_UP("half_up", Direction.UP),
    HALF_DOWN("half_down", Direction.DOWN),
    FULL("full", Direction.UP);

    private final String name;
    private final Direction facing;

    private DirectionalSlabType(String name, Direction facing) {
        this.name = name;
        this.facing = facing;
    }

    public static DirectionalSlabType getHalfFrom(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> HALF_DOWN;
            case Direction.UP -> HALF_UP;
            case Direction.NORTH -> HALF_NORTH;
            case Direction.SOUTH -> HALF_SOUTH;
            case Direction.WEST -> HALF_WEST;
            case Direction.EAST -> HALF_EAST;
        };
    }

    public static DirectionalSlabType getHalfFrom(BlockPos clickedPos, Vec3 clickLocation, Direction clickedFace) {
        Vec3 relativeClickPos = clickLocation.m_82546_(Vec3.m_82528_((Vec3i)clickedPos));
        if (clickedFace.m_122434_() == Direction.Axis.Y) {
            float x = (float)relativeClickPos.f_82479_;
            float z = (float)relativeClickPos.f_82481_;
            Sector clickedSector = DirectionalSlabType.getClickedSector(x, z);
            return switch (clickedSector) {
                default -> throw new IncompatibleClassChangeError();
                case Sector.MIDDLE -> {
                    if (clickedFace == Direction.UP) {
                        yield HALF_UP;
                    }
                    yield HALF_DOWN;
                }
                case Sector.NORTH -> HALF_SOUTH;
                case Sector.EAST -> HALF_WEST;
                case Sector.SOUTH -> HALF_NORTH;
                case Sector.WEST -> HALF_EAST;
            };
        }
        if (clickedFace.m_122434_() == Direction.Axis.X) {
            float x = (float)relativeClickPos.f_82481_;
            float y = (float)relativeClickPos.f_82480_;
            Sector clickedSector = DirectionalSlabType.getClickedSector(x, y);
            return switch (clickedSector) {
                default -> throw new IncompatibleClassChangeError();
                case Sector.MIDDLE -> {
                    if (clickedFace == Direction.WEST) {
                        yield HALF_WEST;
                    }
                    yield HALF_EAST;
                }
                case Sector.NORTH -> HALF_UP;
                case Sector.SOUTH -> HALF_DOWN;
                case Sector.EAST -> HALF_NORTH;
                case Sector.WEST -> HALF_SOUTH;
            };
        }
        if (clickedFace.m_122434_() == Direction.Axis.Z) {
            float z = (float)relativeClickPos.f_82479_;
            float y = (float)relativeClickPos.f_82480_;
            Sector clickedSector = DirectionalSlabType.getClickedSector(z, y);
            return switch (clickedSector) {
                default -> throw new IncompatibleClassChangeError();
                case Sector.MIDDLE -> {
                    if (clickedFace == Direction.SOUTH) {
                        yield HALF_SOUTH;
                    }
                    yield HALF_NORTH;
                }
                case Sector.NORTH -> HALF_UP;
                case Sector.SOUTH -> HALF_DOWN;
                case Sector.EAST -> HALF_WEST;
                case Sector.WEST -> HALF_EAST;
            };
        }
        return DirectionalSlabType.getHalfFrom(clickedFace);
    }

    private static boolean isMiddleSector(float x, float y) {
        double max = 0.6666666666666666;
        double min = 0.3333333333333333;
        return (double)x <= max && (double)x > min && (double)y <= max && (double)y > min;
    }

    private static Sector getClickedSector(float x, float y) {
        if (DirectionalSlabType.isMiddleSector(x, y)) {
            return Sector.MIDDLE;
        }
        Vec2 point = new Vec2(x, y);
        Vec2 middle = new Vec2(0.5f, 0.5f);
        Vec2 a = new Vec2(0.0f, 0.0f);
        Vec2 b = new Vec2(1.0f, 0.0f);
        Vec2 c = new Vec2(1.0f, 1.0f);
        Vec2 d = new Vec2(0.0f, 1.0f);
        if (DirectionalSlabType.isInsideTriangle(middle, a, b, point)) {
            return Sector.NORTH;
        }
        if (DirectionalSlabType.isInsideTriangle(middle, b, c, point)) {
            return Sector.EAST;
        }
        if (DirectionalSlabType.isInsideTriangle(middle, c, d, point)) {
            return Sector.SOUTH;
        }
        if (DirectionalSlabType.isInsideTriangle(middle, d, a, point)) {
            return Sector.WEST;
        }
        return Sector.MIDDLE;
    }

    private static float triangleArea(Vec2 a, Vec2 b, Vec2 c) {
        return 0.5f * Math.abs(a.f_82470_ * (b.f_82471_ - c.f_82471_) + b.f_82470_ * (c.f_82471_ - a.f_82471_) + c.f_82470_ * (a.f_82471_ - b.f_82471_));
    }

    private static boolean isInsideTriangle(Vec2 a, Vec2 b, Vec2 c, Vec2 p) {
        float areaABP;
        float areaAPC;
        float areaPBC;
        float areaABC = DirectionalSlabType.triangleArea(a, b, c);
        return areaABC == (areaPBC = DirectionalSlabType.triangleArea(p, b, c)) + (areaAPC = DirectionalSlabType.triangleArea(a, p, c)) + (areaABP = DirectionalSlabType.triangleArea(a, b, p));
    }

    public DirectionalSlabType rotate(Rotation rotation) {
        if (this.facing.m_122434_() == Direction.Axis.Y) {
            return this;
        }
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> this.getClockWise();
            case Rotation.CLOCKWISE_180 -> DirectionalSlabType.getHalfFrom(this.facing.m_122424_());
            case Rotation.COUNTERCLOCKWISE_90 -> this.getCounterClockWise();
            default -> this;
        };
    }

    public DirectionalSlabType getClockWise() {
        return switch (this.facing) {
            case Direction.NORTH -> DirectionalSlabType.getHalfFrom(Direction.EAST);
            case Direction.SOUTH -> DirectionalSlabType.getHalfFrom(Direction.WEST);
            case Direction.WEST -> DirectionalSlabType.getHalfFrom(Direction.NORTH);
            case Direction.EAST -> DirectionalSlabType.getHalfFrom(Direction.SOUTH);
            default -> this;
        };
    }

    public DirectionalSlabType getCounterClockWise() {
        return switch (this.facing) {
            case Direction.NORTH -> DirectionalSlabType.getHalfFrom(Direction.WEST);
            case Direction.SOUTH -> DirectionalSlabType.getHalfFrom(Direction.EAST);
            case Direction.WEST -> DirectionalSlabType.getHalfFrom(Direction.SOUTH);
            case Direction.EAST -> DirectionalSlabType.getHalfFrom(Direction.NORTH);
            default -> this;
        };
    }

    public DirectionalSlabType mirror(Mirror mirror) {
        OctahedralGroup rotation = mirror.m_54842_();
        if (rotation == OctahedralGroup.INVERT_X && this.facing.m_122434_() == Direction.Axis.X) {
            return DirectionalSlabType.getHalfFrom(this.facing.m_122424_());
        }
        if (rotation == OctahedralGroup.INVERT_Z && this.facing.m_122434_() == Direction.Axis.Z) {
            return DirectionalSlabType.getHalfFrom(this.facing.m_122424_());
        }
        if (rotation == OctahedralGroup.INVERT_Y && this.facing.m_122434_() == Direction.Axis.Y) {
            return DirectionalSlabType.getHalfFrom(this.facing.m_122424_());
        }
        return this;
    }

    public String toString() {
        return this.name;
    }

    public String m_7912_() {
        return this.name;
    }

    public Direction getFacing() {
        return this.facing;
    }

    private static enum Sector {
        MIDDLE,
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

