/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.storagesac;

import com.github.elenterius.biomancy.block.base.WaterloggedFacingEntityBlock;
import com.github.elenterius.biomancy.block.storagesac.StorageSacBlockEntity;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class StorageSacBlock
extends WaterloggedFacingEntityBlock {
    public static final VoxelShape SHAPE_UP = StorageSacBlock.createShape(Direction.UP);
    public static final VoxelShape SHAPE_DOWN = StorageSacBlock.createShape(Direction.DOWN);
    public static final VoxelShape SHAPE_NORTH = StorageSacBlock.createShape(Direction.NORTH);
    public static final VoxelShape SHAPE_SOUTH = StorageSacBlock.createShape(Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = StorageSacBlock.createShape(Direction.WEST);
    public static final VoxelShape SHAPE_EAST = StorageSacBlock.createShape(Direction.EAST);

    public StorageSacBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape createShape(Direction direction) {
        return Shapes.m_83113_((VoxelShape)VoxelShapeUtil.createXZRotatedTowards(direction, 4.0, 0.0, 4.0, 12.0, 2.0, 12.0), (VoxelShape)VoxelShapeUtil.createXZRotatedTowards(direction, 2.0, 2.0, 2.0, 14.0, 16.0, 14.0), (BooleanOp)BooleanOp.f_82695_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StorageSacBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StorageSacBlockEntity) {
            StorageSacBlockEntity sac = (StorageSacBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                sac.setCustomName(stack.m_41786_());
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        StorageSacBlockEntity sac;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StorageSacBlockEntity && (sac = (StorageSacBlockEntity)blockEntity).canPlayerInteract(player)) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)sac, buffer -> buffer.m_130064_(pos));
                SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.UI_STORAGE_SAC_OPEN);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        StorageSacBlockEntity storage;
        BlockEntity blockEntity;
        if (!level.f_46443_ && player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof StorageSacBlockEntity && !(storage = (StorageSacBlockEntity)blockEntity).isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            storage.m_187476_(stack);
            if (storage.m_8077_()) {
                stack.m_41714_(storage.m_7770_());
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (StorageSacBlock.getFacing(state)) {
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_UP;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

