/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.client.gui.BioForgeScreenController;
import com.github.elenterius.biomancy.client.gui.component.CustomEditBox;
import com.github.elenterius.biomancy.client.gui.tooltip.ScreenNutrientFuelConsumer;
import com.github.elenterius.biomancy.client.gui.tooltip.ScreenTooltipStyleProvider;
import com.github.elenterius.biomancy.client.util.ClientSoundUtil;
import com.github.elenterius.biomancy.client.util.GuiRenderUtil;
import com.github.elenterius.biomancy.client.util.GuiUtil;
import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.BioForgingRecipe;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.menu.BioForgeMenu;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class BioForgeScreen
extends AbstractContainerScreen<BioForgeMenu>
implements ScreenTooltipStyleProvider,
ScreenNutrientFuelConsumer {
    private static final ResourceLocation BACKGROUND_TEXTURE = BiomancyMod.createRL("textures/gui/menu_bio_forge.png");
    private final TabsHelper tabsHelper = new TabsHelper();
    private final IngredientsHelper ingredientsHelper = new IngredientsHelper();
    private BioForgeScreenController recipeBook;
    private CustomEditBox searchInput;
    private boolean ignoreTextInput;
    private float time;

    public BioForgeScreen(BioForgeMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 292;
        this.f_97727_ = 219;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchInput = new CustomEditBox(Objects.requireNonNull(this.f_96541_).f_91062_, this.f_97735_ + 26, this.f_97736_ + 16, 78, 14, (Component)ComponentUtil.translatable("itemGroup.search"));
        this.searchInput.m_94199_(50);
        this.searchInput.setTextHint((Component)ComponentUtil.translatable("gui.recipebook.search_hint").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(5325370)));
        this.searchInput.m_94202_(11044723);
        this.recipeBook = new BioForgeScreenController(this.f_96541_, (BioForgeMenu)this.f_97732_);
    }

    public void onRecipeBookUpdated() {
        this.recipeBook.onRecipeBookUpdated();
    }

    protected void m_181908_() {
        this.searchInput.m_94120_();
        this.recipeBook.tick();
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchInput.m_6375_(mouseX, mouseY, button)) {
            this.searchInput.m_93692_(true);
            return true;
        }
        this.searchInput.m_93692_(false);
        if (this.recipeBook.hasRecipesOnPage()) {
            int recipes = this.recipeBook.getMaxRecipesOnGrid();
            for (int i = 0; i < recipes; ++i) {
                int pX = this.f_97735_ + 13 + 23 * (i % 4);
                int pY = this.f_97736_ + 37 + 23 * (i / 4);
                if (!GuiUtil.isInRect(pX, pY, 24, 24, mouseX, mouseY)) continue;
                ClientSoundUtil.playUISound(ModSoundEvents.UI_BIO_FORGE_SELECT_RECIPE);
                this.recipeBook.setSelectedRecipe(i);
                return true;
            }
            if (this.recipeBook.getMaxPages() > 1) {
                int x = this.f_97735_ + 60 + 1;
                Objects.requireNonNull(this.f_96547_);
                int y = this.f_97736_ + 211 - 9 * 2 - 2;
                if (this.recipeBook.hasPrevPage() && GuiUtil.isInRect(x - 22 - 8 - 1, y, 8, 13, mouseX, mouseY)) {
                    ClientSoundUtil.playUISound(ModSoundEvents.UI_BUTTON_CLICK);
                    this.recipeBook.goToPrevPage();
                    return true;
                }
                if (this.recipeBook.hasNextPage() && GuiUtil.isInRect(x + 22, y, 8, 13, mouseX, mouseY)) {
                    ClientSoundUtil.playUISound(ModSoundEvents.UI_BUTTON_CLICK);
                    this.recipeBook.goToNextPage();
                    return true;
                }
            }
        }
        if (this.tabsHelper.clickMouse(mouseX, mouseY)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        if (this.searchInput.m_7933_(keyCode, scanCode, modifiers)) {
            this.recipeBook.updateSearchString(this.searchInput.m_94155_().toLowerCase(Locale.ROOT));
            return true;
        }
        if (this.searchInput.m_93696_() && this.searchInput.m_94213_() && keyCode != 256) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92098_.m_90832_(keyCode, scanCode) && !this.searchInput.m_93696_()) {
            this.ignoreTextInput = true;
            this.searchInput.m_93692_(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.searchInput.m_5534_(codePoint, modifiers)) {
            this.recipeBook.updateSearchString(this.searchInput.m_94155_().toLowerCase(Locale.ROOT));
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void blit(GuiGraphics guiGraphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        guiGraphics.m_280398_(BACKGROUND_TEXTURE, x, y, 0, (float)uOffset, (float)vOffset, uWidth, vHeight, 512, 256);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!Screen.m_96637_()) {
            this.time += partialTick;
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.blit(guiGraphics, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderFuelBar(guiGraphics);
        this.tabsHelper.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.ingredientsHelper.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderRecipeResult(guiGraphics);
        this.renderRecipeSelectionGrid(guiGraphics);
        this.searchInput.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderRecipeResult(GuiGraphics guiGraphics) {
        BioForgingRecipe selectedRecipe = this.recipeBook.getSelectedRecipe();
        if (selectedRecipe != null && ((BioForgeMenu)this.f_97732_).isResultEmpty()) {
            ItemStack stack = selectedRecipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
            int x = this.f_97735_ + 194 + 2;
            int y = this.f_97736_ + 33 + 2;
            guiGraphics.m_280509_(x, y, x + 16, y + 16, 0x30FF0000);
            guiGraphics.m_280203_(stack, x, y);
            guiGraphics.m_285944_(RenderType.m_285811_(), x, y, x + 16, y + 16, 0x30FFFFFF);
            guiGraphics.m_280370_(this.f_96547_, stack, x, y);
        }
    }

    private void renderRecipeSelectionGrid(GuiGraphics guiGraphics) {
        if (!this.recipeBook.hasRecipesOnPage()) {
            return;
        }
        if (this.recipeBook.hasSelectedRecipe() && this.recipeBook.isSelectedRecipeVisible()) {
            int gridIndex = this.recipeBook.getGridIndexOfSelectedRecipe();
            BioForgingRecipe recipe = this.recipeBook.getRecipeByGrid(gridIndex);
            boolean isCraftable = this.recipeBook.getRecipeCollectionByGrid(gridIndex).m_100506_((Recipe)recipe);
            this.renderTileSelection(guiGraphics, gridIndex, isCraftable);
        }
        int maxRecipes = this.recipeBook.getMaxRecipesOnGrid();
        for (int gridIndex = 0; gridIndex < maxRecipes; ++gridIndex) {
            BioForgingRecipe recipe = this.recipeBook.getRecipeByGrid(gridIndex);
            boolean isCraftable = this.recipeBook.getRecipeCollectionByGrid(gridIndex).m_100506_((Recipe)recipe);
            this.renderRecipeTile(guiGraphics, gridIndex, isCraftable, recipe.m_8043_(this.f_96541_.f_91073_.m_9598_()));
        }
        this.renderPagination(guiGraphics);
    }

    private void renderPagination(GuiGraphics guiGraphics) {
        if (this.recipeBook.getMaxPages() < 2) {
            return;
        }
        int x = this.f_97735_ + 60 + 1;
        Objects.requireNonNull(this.f_96547_);
        int y = this.f_97736_ + 211 - 9 * 2 - 2;
        int currentPage = this.recipeBook.getCurrentPage();
        if (currentPage > 1) {
            this.blit(guiGraphics, x - 22 - 8 - 1, y, 298, 58, 8, 13);
        }
        if (currentPage < this.recipeBook.getMaxPages()) {
            this.blit(guiGraphics, x + 22, y, 334, 58, 8, 13);
        }
        String text = "%d/%d".formatted(currentPage, this.recipeBook.getMaxPages());
        guiGraphics.m_280488_(this.f_96547_, text, (int)((float)x - (float)this.f_96547_.m_92895_(text) / 2.0f), y + 3, 11044723);
    }

    private void renderRecipeTile(GuiGraphics guiGraphics, int idx, boolean isCraftable, ItemStack stack) {
        int x = this.f_97735_ + 12 + 25 * (idx % 4);
        int y = this.f_97736_ + 36 + 25 * (idx / 4);
        this.renderRecipeTile(guiGraphics, x, y, stack, !isCraftable);
    }

    private void renderRecipeTile(GuiGraphics guiGraphics, int x, int y, ItemStack stack, boolean redOverlay) {
        this.blit(guiGraphics, x, y, 295, 30, 22, 22);
        if (redOverlay) {
            this.blit(guiGraphics, x, y, 323, 30, 22, 22);
            guiGraphics.m_280480_(stack, x + 3, y + 3);
            RenderSystem.depthFunc((int)516);
            guiGraphics.m_280509_(x, y, x + 22, y + 22, 1086400295);
            RenderSystem.depthFunc((int)515);
        } else {
            guiGraphics.m_280480_(stack, x + 3, y + 3);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
    }

    private void renderTileSelection(GuiGraphics guiGraphics, int idx, boolean isValid) {
        int x = this.f_97735_ + 12 + 25 * (idx % 4) - 1;
        int y = this.f_97736_ + 36 + 25 * (idx / 4) - 1;
        this.blit(guiGraphics, x, y, isValid ? 295 : 321, 2, 24, 24);
    }

    private void renderFuelBar(GuiGraphics guiGraphics) {
        int cost;
        float fuelPct = ((BioForgeMenu)this.f_97732_).getFuelAmountNormalized();
        int vHeight = (int)(fuelPct * 36.0f) + (fuelPct > 0.0f ? 1 : 0);
        this.blit(guiGraphics, this.f_97735_ + 144, this.f_97736_ + 13 + 36 - vHeight, 353, 45 - vHeight, 5, vHeight);
        BioForgingRecipe selectedRecipe = this.recipeBook.getSelectedRecipe();
        int n = cost = selectedRecipe != null ? selectedRecipe.getCraftingCostNutrients() : 0;
        if (cost <= ((BioForgeMenu)this.f_97732_).getFuelAmount()) {
            return;
        }
        int x = this.f_97735_ + 144;
        int y = this.f_97736_ + 13 + 36 - ((int)((float)cost / (float)((BioForgeMenu)this.f_97732_).getMaxFuelAmount() * 36.0f) + 1);
        guiGraphics.m_280509_(x - 3, y, x + 5 + 3, y + 1, 0x30FF0000);
        guiGraphics.m_280509_(x + 5 + 3, y, x + 5 + 3 + 1, y + 1, -65536);
        guiGraphics.m_280509_(x + 5 + 3 + 1, y - 1, x + 5 + 3 + 2, y + 2, -65536);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((BioForgeMenu)this.f_97732_).m_142621_().m_41619_()) {
            if (this.tabsHelper.renderTooltip(guiGraphics, mouseX, mouseY)) {
                return;
            }
            if (this.renderFuelTooltip(guiGraphics, mouseX, mouseY)) {
                return;
            }
            if (this.renderRecipeSelectionGridTooltip(guiGraphics, mouseX, mouseY)) {
                return;
            }
            if (this.ingredientsHelper.renderTooltip(guiGraphics, mouseX, mouseY)) {
                return;
            }
        }
        super.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean renderRecipeSelectionGridTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.recipeBook.hasRecipesOnPage()) {
            int minX = this.f_97735_ + 13;
            int minY = this.f_97736_ + 37;
            int maxX = this.f_97735_ + 13 + 100 - 5;
            int maxIndex = this.recipeBook.getMaxRecipesOnGrid();
            int maxY = this.f_97736_ + 37 + 25 * Mth.m_14167_((float)((float)maxIndex / 4.0f)) - 5;
            if (!GuiUtil.isInRectAB(minX, minY, maxX, maxY, mouseX, mouseY)) {
                return false;
            }
            for (int index = 0; index < maxIndex; ++index) {
                int x = this.f_97735_ + 13 + 25 * (index % 4);
                int y = this.f_97736_ + 37 + 25 * (index / 4);
                if (!GuiUtil.isInRect(x, y, 20, 20, mouseX, mouseY)) continue;
                guiGraphics.m_280153_(this.f_96547_, this.recipeBook.getRecipeByGrid(index).m_8043_(this.f_96541_.f_91073_.m_9598_()), mouseX, mouseY);
                return true;
            }
        }
        return false;
    }

    private boolean renderFuelTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!GuiUtil.isInRect(this.f_97735_ + 144, this.f_97736_ + 13, 5, 36, mouseX, mouseY)) {
            return false;
        }
        int maxFuel = ((BioForgeMenu)this.f_97732_).getMaxFuelAmount();
        int fuelAmount = ((BioForgeMenu)this.f_97732_).getFuelAmount();
        BioForgingRecipe selectedRecipe = this.recipeBook.getSelectedRecipe();
        int totalFuelCost = selectedRecipe != null ? selectedRecipe.getCraftingCostNutrients() : 0;
        GuiRenderUtil.drawFuelTooltip(this.f_96547_, guiGraphics, mouseX, mouseY, maxFuel, fuelAmount, totalFuelCost);
        return true;
    }

    private final class TabsHelper
    implements Renderable {
        private static final int WIDTH = 24;
        private static final int HEIGHT = 32;
        private static final int Y_OFFSET = 7;

        private TabsHelper() {
        }

        private boolean clickMouse(double mouseX, double mouseY) {
            for (int i = 0; i < BioForgeScreen.this.recipeBook.getTabCount(); ++i) {
                int pX = BioForgeScreen.this.f_97735_ - 24;
                int pY = BioForgeScreen.this.f_97736_ + 7 + 32 * i;
                if (BioForgeScreen.this.recipeBook.isActiveTab(i) || !GuiUtil.isInRect(pX, pY + 3, 24, 29, mouseX, mouseY)) continue;
                ClientSoundUtil.playUISound(ModSoundEvents.UI_BUTTON_CLICK);
                BioForgeScreen.this.recipeBook.setActiveTab(i);
                return true;
            }
            return false;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            for (int index = 0; index < BioForgeScreen.this.recipeBook.getTabCount(); ++index) {
                this.renderTab(guiGraphics, index, BioForgeScreen.this.recipeBook.isActiveTab(index), BioForgeScreen.this.recipeBook.getTab(index).getIcon());
            }
        }

        private void renderTab(GuiGraphics guiGraphics, int index, boolean isActive, ItemStack stack) {
            int x = BioForgeScreen.this.f_97735_ - 24 + 2;
            int y = BioForgeScreen.this.f_97736_ + 7 + 32 * index;
            BioForgeScreen.this.blit(guiGraphics, x, y, 297, isActive ? 114 : 78, 24, 32);
            guiGraphics.m_280480_(stack, x + 5, y + 8);
        }

        private boolean renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            int maxY;
            int maxX;
            int minY;
            int minX = BioForgeScreen.this.f_97735_ - 24 + 2;
            if (!GuiUtil.isInRectAB(minX, minY = BioForgeScreen.this.f_97736_ + 7, maxX = BioForgeScreen.this.f_97735_, maxY = BioForgeScreen.this.f_97736_ + 7 + 32 * BioForgeScreen.this.recipeBook.getTabCount(), mouseX, mouseY)) {
                return false;
            }
            for (int index = 0; index < BioForgeScreen.this.recipeBook.getTabCount(); ++index) {
                int y;
                int x = BioForgeScreen.this.f_97735_ - 24 + 2;
                if (!GuiUtil.isInRect(x, y = BioForgeScreen.this.f_97736_ + 7 + 32 * index, 24, 32, mouseX, mouseY)) continue;
                guiGraphics.m_280557_(BioForgeScreen.this.f_96547_, (Component)ComponentUtil.translatable(BioForgeScreen.this.recipeBook.getTab(index).translationKey()), mouseX, mouseY);
                return true;
            }
            return false;
        }
    }

    private final class IngredientsHelper
    implements Renderable {
        private static final int X_OFFSET = 144;
        private static final int Y_OFFSET = 85;

        private IngredientsHelper() {
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            BioForgingRecipe recipe = BioForgeScreen.this.recipeBook.getSelectedRecipe();
            if (recipe == null) {
                return;
            }
            int x = BioForgeScreen.this.f_97735_ + 144;
            int y = BioForgeScreen.this.f_97736_ + 85;
            List<IngredientStack> ingredients = recipe.getIngredientQuantities();
            for (int i = 0; i < ingredients.size(); ++i) {
                IngredientStack ingredientStack = ingredients.get(i);
                ItemStack[] items = ingredientStack.getItems();
                ItemStack itemStack = items[Mth.m_14143_((float)(BioForgeScreen.this.time / 30.0f)) % items.length];
                boolean isSufficientCount = BioForgeScreen.this.recipeBook.hasSufficientIngredientCount(ingredientStack);
                this.renderItemWithQuantity(guiGraphics, itemStack, isSufficientCount, ingredientStack.count(), x + 26 * i, y);
            }
        }

        private void renderItemWithQuantity(GuiGraphics guiGraphics, ItemStack stack, boolean isSufficientCount, int requiredCount, int x, int y) {
            BioForgeScreen.this.blit(guiGraphics, x - 3, y - 3, isSufficientCount ? 330 : 354, 74, 22, 22);
            guiGraphics.m_280480_(stack, x, y);
            String text = "x" + requiredCount;
            guiGraphics.m_280488_(BioForgeScreen.this.f_96547_, text, x + 16 + 4 - BioForgeScreen.this.f_96547_.m_92895_(text), y + 16 + 4 + 1, isSufficientCount ? 6665514 : 12658471);
        }

        private boolean renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            BioForgingRecipe selectedRecipe = BioForgeScreen.this.recipeBook.getSelectedRecipe();
            if (selectedRecipe == null) {
                return false;
            }
            List<IngredientStack> ingredients = selectedRecipe.getIngredientQuantities();
            for (int i = 0; i < ingredients.size(); ++i) {
                int y;
                int x = BioForgeScreen.this.f_97735_ + 144 + 26 * i;
                if (!GuiUtil.isInRect(x, y = BioForgeScreen.this.f_97736_ + 85, 20, 20, mouseX, mouseY)) continue;
                ItemStack[] items = ingredients.get(i).ingredient().m_43908_();
                ItemStack itemStack = items[Mth.m_14143_((float)(BioForgeScreen.this.time / 30.0f)) % items.length];
                guiGraphics.m_280153_(BioForgeScreen.this.f_96547_, itemStack, mouseX, mouseY);
                return true;
            }
            return false;
        }
    }
}

