/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.particle;

import com.github.elenterius.biomancy.util.colors.ColorHarmony;
import com.github.elenterius.biomancy.util.colors.ColorSpace;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomGlowParticle
extends TextureSheetParticle {
    static final RandomSource RANDOM = RandomSource.m_216327_();
    private final SpriteSet sprites;

    protected CustomGlowParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.f_107663_ *= 0.75f;
        this.f_172258_ = 0.99f;
        this.f_107219_ = false;
        this.m_108339_(sprites);
        this.f_107215_ *= (double)0.02f;
        this.f_107216_ *= (double)0.02f;
        this.f_107217_ *= (double)0.02f;
        this.f_107225_ = 20 + level.m_213780_().m_188503_(81);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float partialTick) {
        int lightColor = super.m_6355_(partialTick);
        int k = lightColor >> 16 & 0xFF;
        float agePct = Mth.m_14036_((float)(((float)this.f_107224_ + partialTick) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        int brightness = (lightColor & 0xFF) + (int)(agePct * 15.0f * 16.0f);
        return Math.min(brightness, 240) | k << 16;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
    }

    public void setColorRGB(int color) {
        this.f_107227_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        this.f_107228_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        this.f_107229_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GenericProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GenericProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CustomGlowParticle(level, x, y, z, 0.5 - RANDOM.m_188500_(), ySpeed, 0.5 - RANDOM.m_188500_(), this.sprite);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TwoColorProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;
        private final int primaryColor;
        private final int secondaryColor;

        public TwoColorProvider(SpriteSet sprites, int primaryColor, int secondaryColor) {
            this.sprite = sprites;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CustomGlowParticle particle = new CustomGlowParticle(level, x, y, z, 0.5 - RANDOM.m_188500_(), ySpeed, 0.5 - RANDOM.m_188500_(), this.sprite);
            particle.setColorRGB(level.f_46441_.m_188501_() < 0.4f ? this.secondaryColor : this.primaryColor);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AnalogousColorProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;
        private final int color;

        public AnalogousColorProvider(SpriteSet sprites, int rgbColor) {
            this.sprite = sprites;
            this.color = rgbColor;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CustomGlowParticle particle = new CustomGlowParticle(level, x, y, z, 0.5 - RANDOM.m_188500_(), ySpeed, 0.5 - RANDOM.m_188500_(), this.sprite);
            if (level.f_46441_.m_188501_() < 0.4f) {
                double[][] colors = ColorHarmony.analogousOkLCh(ColorSpace.OkLCh.fromARGB32(this.color));
                double[] rgb = ColorSpace.OkLCh.toSRGB(colors[1]);
                particle.m_107253_((float)rgb[0], (float)rgb[1], (float)rgb[2]);
            } else {
                particle.setColorRGB(this.color);
            }
            return particle;
        }
    }
}

