/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.render;

import com.github.elenterius.biomancy.block.DirectionalSlabBlock;
import com.github.elenterius.biomancy.block.property.DirectionalSlabType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class RenderHighlightHandler {
    private RenderHighlightHandler() {
    }

    @SubscribeEvent
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        BlockItem blockItem;
        Player player;
        ItemStack itemStack;
        Item item;
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof Player && (item = (itemStack = (player = (Player)entity).m_21205_()).m_41720_()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof DirectionalSlabBlock) {
            DirectionalSlabBlock slabBlock = (DirectionalSlabBlock)item;
            BlockPlaceContext placeContext = new BlockPlaceContext(player, InteractionHand.MAIN_HAND, itemStack, event.getTarget());
            BlockPos placePos = placeContext.m_8083_();
            BlockState foundState = player.m_9236_().m_8055_(placePos);
            DirectionalSlabType type = foundState.m_60734_() instanceof DirectionalSlabBlock ? DirectionalSlabType.getHalfFrom(((DirectionalSlabType)((Object)foundState.m_61143_(DirectionalSlabBlock.TYPE))).getFacing().m_122424_()) : DirectionalSlabType.getHalfFrom(placePos, placeContext.m_43720_(), placeContext.m_43719_());
            BlockState state = (BlockState)slabBlock.m_49966_().m_61124_(DirectionalSlabBlock.TYPE, (Comparable)((Object)type));
            double cameraX = event.getCamera().m_90583_().f_82479_;
            double cameraY = event.getCamera().m_90583_().f_82480_;
            double cameraZ = event.getCamera().m_90583_().f_82481_;
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraX, -cameraY, -cameraZ);
            RenderHighlightHandler.renderBlock(poseStack, event.getMultiBufferSource(), state, placePos);
            poseStack.m_85849_();
        }
    }

    public static void renderBlock(PoseStack poseStack, MultiBufferSource buffer, BlockState state, BlockPos pos) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        Minecraft.m_91087_().m_91289_().m_110912_(state, poseStack, AlphaBuffer.of(buffer, 0.7f), 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    private static final class AlphaBuffer
    implements MultiBufferSource {
        private static final AlphaBuffer delegate = new AlphaBuffer();
        private MultiBufferSource internalBuffer;
        private float alpha;

        private AlphaBuffer() {
        }

        public static MultiBufferSource of(MultiBufferSource bufferSource, float alpha) {
            AlphaBuffer.delegate.internalBuffer = bufferSource;
            AlphaBuffer.delegate.alpha = alpha;
            return delegate;
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            return this.internalBuffer.m_6299_((RenderType)AlphaRenderType.of(renderType, this.alpha));
        }
    }

    private static class AlphaRenderType
    extends RenderType {
        private static final Map<RenderType, AlphaRenderType> remappedTypes = new IdentityHashMap<RenderType, AlphaRenderType>();
        private static float alpha;

        private AlphaRenderType(RenderType original) {
            super(String.format("%s_%s_alpha", original, "biomancy"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.m_110188_();
            });
        }

        public static AlphaRenderType of(RenderType renderType, float alpha) {
            AlphaRenderType alphaType;
            AlphaRenderType.alpha = alpha;
            return renderType instanceof AlphaRenderType ? (alphaType = (AlphaRenderType)renderType) : remappedTypes.computeIfAbsent(renderType, AlphaRenderType::new);
        }
    }
}

