/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.render.block.storagesac;

import com.github.elenterius.biomancy.block.storagesac.StorageSacBlock;
import com.github.elenterius.biomancy.block.storagesac.StorageSacBlockEntity;
import com.github.elenterius.biomancy.util.ItemStackCounter;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class StorageSacRenderer
implements BlockEntityRenderer<StorageSacBlockEntity> {
    private final RandomSource random = RandomSource.m_216327_();
    private final ItemRenderer itemRenderer;

    public StorageSacRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    private float randomOffset(float amount) {
        return (this.random.m_188501_() * 2.0f - 1.0f) * amount;
    }

    public void render(StorageSacBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int seed = (int)blockEntity.m_58899_().m_121878_() + blockEntity.m_58899_().m_123341_() - 1;
        this.random.m_188584_((long)seed);
        ItemTranslator itemTranslator = ItemTranslator.from(StorageSacBlock.getFacing(blockEntity.m_58900_()));
        this.renderItemsOnAxis(poseStack, bufferSource, packedLight, packedOverlay, blockEntity.getItemsForRendering(), itemTranslator, 0.375f);
    }

    private void renderItemsOnAxis(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, List<ItemStackCounter.CountedItem> items, ItemTranslator itemTranslator, float itemScale) {
        int numberOfItems = items.size();
        for (int i = 0; i < numberOfItems; ++i) {
            ItemStack stack = items.get(i).stack();
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            float x = 0.5f + this.randomOffset(0.175f);
            float y = 0.25f + ((float)i + 1.0f) / (float)numberOfItems * 0.5f;
            float z = 0.5f + this.randomOffset(0.175f);
            itemTranslator.translate(poseStack, x, y, z);
            int amount = stack.m_41613_();
            for (int j = 0; j < amount; ++j) {
                poseStack.m_85836_();
                if (j > 0) {
                    float x2 = this.randomOffset(0.075f);
                    float y2 = this.randomOffset(0.1f);
                    float z2 = this.randomOffset(0.075f);
                    itemTranslator.translate(poseStack, x2, y2, z2);
                }
                poseStack.m_85841_(itemScale, itemScale, itemScale);
                this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, null, 0);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    static enum ItemTranslator {
        X_AXIS((poseStack, x, y, z) -> poseStack.m_252880_(y, x, z)),
        Y_AXIS(PoseStack::m_252880_),
        Z_AXIS((poseStack, x, y, z) -> poseStack.m_252880_(x, z, y));

        private final TranslationFunc translationFunc;

        private ItemTranslator(TranslationFunc translationFunc) {
            this.translationFunc = translationFunc;
        }

        static ItemTranslator from(Direction facing) {
            Direction.Axis axis = facing.m_122434_();
            if (axis == Direction.Axis.X) {
                return X_AXIS;
            }
            if (axis == Direction.Axis.Y) {
                return Y_AXIS;
            }
            return Z_AXIS;
        }

        void translate(PoseStack poseStack, float x, float y, float z) {
            this.translationFunc.translate(poseStack, x, y, z);
        }

        static interface TranslationFunc {
            public void translate(PoseStack var1, float var2, float var3, float var4);
        }
    }
}

