/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.util;

import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class GuiRenderUtil {
    protected static final ResourceLocation GUI_ICONS_TEXTURE = new ResourceLocation("textures/gui/icons.png");

    private GuiRenderUtil() {
    }

    public static void drawFuelTooltip(Font font, GuiGraphics guiGraphics, int mouseX, int mouseY, int maxFuel, int fuelAmount, int totalFuelCost) {
        ArrayList<MutableComponent> hoveringText = new ArrayList<MutableComponent>();
        DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
        hoveringText.add(ComponentUtil.translatable("tooltip.biomancy.nutrients_fuel").m_130948_(TextStyles.NUTRIENTS));
        hoveringText.add(ComponentUtil.literal("%s/%s u".formatted(df.format(fuelAmount), df.format(maxFuel))));
        if (totalFuelCost > 0) {
            hoveringText.add(ComponentUtil.translatable("tooltip.biomancy.nutrients_consumes", df.format(totalFuelCost)).m_130948_(TextStyles.NUTRIENTS_CONSUMPTION));
        }
        guiGraphics.m_280666_(font, hoveringText, mouseX, mouseY);
    }

    public static void drawAttackIndicator(GuiGraphics guiGraphics, int x, int y, float pct) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        guiGraphics.m_280218_(GUI_ICONS_TEXTURE, x, y, 36, 94, 16, 4);
        guiGraphics.m_280218_(GUI_ICONS_TEXTURE, x, y, 52, 94, (int)(pct * 17.0f), 4);
    }

    public static void drawSquareProgressBar(GuiGraphics guiGraphics, int centerX, int centerY, int blitOffset, int radius, float pct) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GuiRenderUtil.drawSquareProgressBar(guiGraphics, centerX, centerY, radius, blitOffset, pct, -1);
    }

    private static void drawSquareProgressBar(GuiGraphics guiGraphics, int centerX, int centerY, int radius, int blitOffset, float pct, int argbColor) {
        int y;
        int x;
        int size = 1;
        int sideLength = radius * 2;
        int halfLength = radius;
        int currentLength = Math.round(pct * (float)(sideLength * 4));
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        int dist = Math.min(currentLength, halfLength);
        if (dist > 0) {
            int y2 = centerY - halfLength;
            GuiRenderUtil.drawQuad(matrix4f, centerX, y2 - size, centerX + halfLength, y2 + size, blitOffset, argbColor);
        }
        if ((dist = Math.min(currentLength - halfLength, sideLength)) > 0) {
            x = centerX + halfLength;
            y = centerY - halfLength;
            GuiRenderUtil.drawQuad(matrix4f, x - size, y, x + size, y + dist, blitOffset, argbColor);
        }
        if ((dist = Math.min(currentLength - 3 * halfLength, sideLength)) > 0) {
            x = centerX + halfLength;
            y = centerY + halfLength;
            GuiRenderUtil.drawQuad(matrix4f, x - dist, y - size, x, y + size, blitOffset, argbColor);
        }
        if ((dist = Math.min(currentLength - 5 * halfLength, sideLength)) > 0) {
            x = centerX - halfLength;
            y = centerY + halfLength;
            GuiRenderUtil.drawQuad(matrix4f, x - size, y - dist, x + size, y, blitOffset, argbColor);
        }
        if ((dist = Math.min(currentLength - 7 * halfLength, halfLength)) > 0) {
            x = centerX - halfLength;
            y = centerY - halfLength;
            GuiRenderUtil.drawQuad(matrix4f, x, y - size, x + halfLength, y + size, blitOffset, argbColor);
        }
        RenderSystem.disableBlend();
    }

    private static void drawQuad(Matrix4f matrix4f, int minX, int minY, int maxX, int maxY, int z, int argbColor) {
        int n;
        if (minX < maxX) {
            n = minX;
            minX = maxX;
            maxX = n;
        }
        if (minY < maxY) {
            n = minY;
            minY = maxY;
            maxY = n;
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix4f, (float)minX, (float)maxY, (float)z).m_193479_(argbColor).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)maxX, (float)maxY, (float)z).m_193479_(argbColor).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)maxX, (float)minY, (float)z).m_193479_(argbColor).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)minX, (float)minY, (float)z).m_193479_(argbColor).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void fill(GuiGraphics guiGraphics, float minX, float minY, float maxX, float maxY, int z, int colorARGB) {
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix4f, minX, maxY, (float)z).m_193479_(colorARGB).m_5752_();
        bufferbuilder.m_252986_(matrix4f, maxX, maxY, (float)z).m_193479_(colorARGB).m_5752_();
        bufferbuilder.m_252986_(matrix4f, maxX, minY, (float)z).m_193479_(colorARGB).m_5752_();
        bufferbuilder.m_252986_(matrix4f, minX, minY, (float)z).m_193479_(colorARGB).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }
}

