/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting;

import com.github.elenterius.biomancy.util.ItemStackCounter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record IngredientStack(Ingredient ingredient, int count) {
    public static final String ALT_INGREDIENT_KEY = "alt";
    public static final String COUNT_KEY = "count";

    public ItemStack[] getItems() {
        return this.ingredient.m_43908_();
    }

    public boolean testItem(@Nullable ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public boolean hasSufficientCount(StackedContents itemCounter) {
        IntList stackingIds = this.ingredient.m_43931_();
        int n = 0;
        for (int i = 0; i < stackingIds.size(); ++i) {
            if ((n += itemCounter.f_36451_.get(stackingIds.getInt(i))) < this.count) continue;
            return true;
        }
        return false;
    }

    public boolean hasSufficientCount(ItemStackCounter itemCounter) {
        List<ItemStackCounter.CountedItem> itemCounts = itemCounter.getItemCounts();
        int n = 0;
        for (ItemStackCounter.CountedItem countedItem : itemCounts) {
            if (this.ingredient.test(countedItem.stack())) {
                n += countedItem.amount();
            }
            if (n < this.count) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getItemsWithCount() {
        if (this.count == 1) {
            return List.of(this.ingredient.m_43908_());
        }
        return Arrays.stream(this.ingredient.m_43908_()).map(this::copyItemStackWithCount).toList();
    }

    private ItemStack copyItemStackWithCount(ItemStack stack) {
        if (this.count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(this.count);
        return copy;
    }

    public JsonObject toJson() {
        JsonElement ingredientJson = this.ingredient.m_43942_();
        if (ingredientJson.isJsonArray()) {
            JsonObject json = new JsonObject();
            json.add(ALT_INGREDIENT_KEY, ingredientJson);
            if (this.count > 1) {
                json.addProperty(COUNT_KEY, (Number)this.count);
            }
            return json;
        }
        JsonObject json = (JsonObject)ingredientJson;
        if (this.count > 1) {
            json.addProperty(COUNT_KEY, (Number)this.count);
        }
        return json;
    }

    public static IngredientStack fromJson(JsonObject json) {
        Ingredient ingredient = IngredientStack.readIngredient(json);
        int count = GsonHelper.m_13824_((JsonObject)json, (String)COUNT_KEY, (int)1);
        return new IngredientStack(ingredient, count);
    }

    private static Ingredient readIngredient(JsonObject json) {
        if (GsonHelper.m_13885_((JsonObject)json, (String)ALT_INGREDIENT_KEY)) {
            return Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)ALT_INGREDIENT_KEY));
        }
        return Ingredient.m_43917_((JsonElement)json);
    }

    public static IngredientStack fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int count = buffer.m_130242_();
        return new IngredientStack(ingredient, count);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130130_(this.count);
    }
}

