/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.RecipeUtil;
import com.github.elenterius.biomancy.crafting.recipe.StaticProcessingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BioBrewingRecipe
extends StaticProcessingRecipe {
    public static final short DEFAULT_CRAFTING_COST_NUTRIENTS = 2;
    public static final int MAX_INGREDIENTS = 4;
    public static final int MAX_REACTANT = 1;
    private final List<IngredientStack> ingredients;
    private final Ingredient recipeReactant;
    private final ItemStack result;
    private final NonNullList<Ingredient> vanillaIngredients;

    public BioBrewingRecipe(ResourceLocation id, ItemStack result, int craftingTimeTicks, int craftingCostNutrients, List<IngredientStack> ingredients, Ingredient reactant) {
        super(id, craftingTimeTicks, craftingCostNutrients);
        this.ingredients = ingredients;
        this.recipeReactant = reactant;
        this.result = result;
        List<Ingredient> flatIngredients = RecipeUtil.flattenIngredientStacks(ingredients);
        this.vanillaIngredients = NonNullList.m_182647_((int)flatIngredients.size());
        this.vanillaIngredients.addAll(flatIngredients);
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        int lastIndex = inv.m_6643_() - 1;
        if (!this.recipeReactant.test(inv.m_8020_(lastIndex))) {
            return false;
        }
        int[] countedIngredients = new int[this.ingredients.size()];
        block0: for (int idx = 0; idx < lastIndex; ++idx) {
            ItemStack stack = inv.m_8020_(idx);
            if (stack.m_41619_()) continue;
            for (int i = 0; i < this.ingredients.size(); ++i) {
                IngredientStack requiredIngredient = this.ingredients.get(i);
                if (!requiredIngredient.testItem(stack) || countedIngredients[i] >= requiredIngredient.count()) continue;
                int n = i;
                countedIngredients[n] = countedIngredients[n] + stack.m_41613_();
                continue block0;
            }
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (countedIngredients[i] >= this.ingredients.get(i).count()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.vanillaIngredients;
    }

    public List<IngredientStack> getIngredientQuantities() {
        return this.ingredients;
    }

    public Ingredient getReactant() {
        return this.recipeReactant;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BIO_BREWING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.BIO_BREWING_RECIPE_TYPE.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.BIO_LAB.get());
    }

    public static class Serializer
    implements RecipeSerializer<BioBrewingRecipe> {
        public BioBrewingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            List<IngredientStack> ingredients = RecipeUtil.readIngredientStacks(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients found for %s recipe".formatted(ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this)));
            }
            if (ingredients.size() > 4) {
                throw new JsonParseException("Too many ingredients for %s recipe. Max amount is %d".formatted(ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this), 4));
            }
            for (IngredientStack ingredientStack : ingredients) {
                int count = ingredientStack.count();
                if (count <= 64) continue;
                throw new IllegalArgumentException("Ingredient quantity of %d is larger than 64".formatted(count));
            }
            Ingredient reactant = json.has("reactant") ? RecipeUtil.readIngredient(json, "reactant") : Ingredient.f_43901_;
            ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"processingTime", (int)100);
            int cost = GsonHelper.m_13824_((JsonObject)json, (String)"nutrientsCost", (int)2);
            return new BioBrewingRecipe(recipeId, resultStack, time, cost, ingredients, reactant);
        }

        @Nullable
        public BioBrewingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack resultStack = buffer.m_130267_();
            Ingredient reactant = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int craftingTime = buffer.m_130242_();
            int craftingCost = buffer.m_130242_();
            int ingredientCount = buffer.m_130242_();
            ArrayList<IngredientStack> ingredients = new ArrayList<IngredientStack>();
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.add(IngredientStack.fromNetwork(buffer));
            }
            return new BioBrewingRecipe(recipeId, resultStack, craftingTime, craftingCost, ingredients, reactant);
        }

        public void toNetwork(FriendlyByteBuf buffer, BioBrewingRecipe recipe) {
            buffer.m_130055_(recipe.result);
            recipe.recipeReactant.m_43923_(buffer);
            buffer.m_130130_(recipe.craftingTimeTicks);
            buffer.m_130130_(recipe.craftingCostNutrients);
            buffer.m_130130_(recipe.ingredients.size());
            for (IngredientStack ingredientStack : recipe.ingredients) {
                ingredientStack.toNetwork(buffer);
            }
        }
    }
}

