/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlock;
import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlockEntity;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.item.EssenceItem;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BiometricMembraneRecipe
extends CustomRecipe {
    public BiometricMembraneRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (!this.m_8004_(container.m_39347_(), container.m_39346_())) {
            return false;
        }
        ItemStack membrane = ItemStack.f_41583_;
        ItemStack essence = ItemStack.f_41583_;
        ItemStack inversion = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.BIOMETRIC_MEMBRANE.get())) {
                if (!membrane.m_41619_()) {
                    return false;
                }
                membrane = stack;
                continue;
            }
            if (stack.m_41720_() instanceof EssenceItem) {
                if (!essence.m_41619_()) {
                    return false;
                }
                essence = stack;
                continue;
            }
            if (stack.m_150930_(Items.f_41978_)) {
                if (!inversion.m_41619_()) {
                    return false;
                }
                inversion = stack;
                continue;
            }
            return false;
        }
        if (membrane.m_41619_()) {
            return false;
        }
        if (essence.m_41619_() && inversion.m_41619_()) {
            return BlockItem.m_186336_((ItemStack)membrane) != null;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack membrane = ItemStack.f_41583_;
        ItemStack essence = ItemStack.f_41583_;
        ItemStack inversion = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.BIOMETRIC_MEMBRANE.get())) {
                if (!membrane.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                membrane = stack;
                continue;
            }
            if (stack.m_41720_() instanceof EssenceItem) {
                if (!essence.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                essence = stack;
                continue;
            }
            if (stack.m_150930_(Items.f_41978_)) {
                if (!inversion.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                inversion = stack;
                continue;
            }
            return ItemStack.f_41583_;
        }
        return !membrane.m_41619_() ? this.createItem(membrane, essence, inversion) : ItemStack.f_41583_;
    }

    public ItemStack createItem(ItemStack membrane, ItemStack essenceStack, ItemStack inversionStack) {
        EssenceItem essenceItem;
        Optional<EntityType<?>> optional;
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)membrane);
        CompoundTag tag = compoundTag != null ? compoundTag.m_128469_("membrane") : new CompoundTag();
        EntityType entityType = EntityType.m_20632_((String)tag.m_128461_("entity_type")).orElse(null);
        UUID entityUUID = tag.m_128403_("entity_uuid") ? tag.m_128342_("entity_uuid") : null;
        int[] entityColors = tag.m_128425_("entity_colors", 11) ? tag.m_128465_("entity_colors") : BiometricMembraneBlockEntity.DEFAULT_COLORS;
        boolean isInverted = tag.m_128471_("is_inverted");
        Item item = essenceStack.m_41720_();
        if (item instanceof EssenceItem && (optional = (essenceItem = (EssenceItem)item).getEntityType(essenceStack)).isPresent()) {
            entityType = optional.orElse(null);
            entityUUID = essenceItem.getEntityUUID(essenceStack).orElse(null);
            entityColors = essenceItem.getColors(essenceStack);
        }
        if (inversionStack.m_150930_(Items.f_41978_)) {
            boolean bl = isInverted = !isInverted;
        }
        if (essenceStack.m_41619_() && inversionStack.m_41619_()) {
            return new ItemStack((ItemLike)ModItems.BIOMETRIC_MEMBRANE.get());
        }
        return BiometricMembraneBlock.createItem(entityType, entityUUID, entityColors, isInverted);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 4;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BIOMETRIC_MEMBRANE_CRAFTING_SERIALIZER.get();
    }
}

