/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.VariableOutput;
import com.github.elenterius.biomancy.crafting.recipe.RecipeUtil;
import com.github.elenterius.biomancy.crafting.recipe.StaticProcessingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DecomposingRecipe
extends StaticProcessingRecipe {
    public static final short DEFAULT_CRAFTING_COST_NUTRIENTS = 1;
    public static final int MAX_INGREDIENTS = 1;
    public static final int MAX_OUTPUTS = 6;
    private final IngredientStack ingredientStack;
    private final NonNullList<Ingredient> vanillaIngredients;
    private final List<VariableOutput> outputs;

    public DecomposingRecipe(ResourceLocation id, List<VariableOutput> outputs, IngredientStack ingredientStack, int craftingTimeTicks, int craftingCostNutrients) {
        super(id, craftingTimeTicks, craftingCostNutrients);
        this.ingredientStack = ingredientStack;
        this.outputs = outputs;
        List<Ingredient> flatIngredients = RecipeUtil.flattenIngredientStacks(List.of(ingredientStack));
        this.vanillaIngredients = NonNullList.m_182647_((int)flatIngredients.size());
        this.vanillaIngredients.addAll(flatIngredients);
    }

    public boolean m_5818_(Container inputInventory, Level level) {
        ItemStack stack = inputInventory.m_8020_(0);
        return this.ingredientStack.ingredient().test(stack) && stack.m_41613_() >= this.ingredientStack.count();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.outputs.get(0).getItemStack();
    }

    public ItemStack m_5874_(Container inputInventory, RegistryAccess registryAccess) {
        return this.outputs.get(0).getItemStack().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 1;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.vanillaIngredients;
    }

    public IngredientStack getIngredientQuantity() {
        return this.ingredientStack;
    }

    public List<VariableOutput> getOutputs() {
        return this.outputs;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.DECOMPOSING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.DECOMPOSING_RECIPE_TYPE.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.DECOMPOSER.get());
    }

    public static class Serializer
    implements RecipeSerializer<DecomposingRecipe> {
        public DecomposingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject input = GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            IngredientStack ingredientStack = IngredientStack.fromJson(input);
            List<VariableOutput> results = RecipeUtil.readVariableProductionOutputs(GsonHelper.m_13933_((JsonObject)json, (String)"results"));
            if (results.size() > 6) {
                throw new JsonParseException(String.format("Too many outputs for %s recipe. Max amount is %d", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this), 6));
            }
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"processingTime", (int)100);
            int cost = GsonHelper.m_13824_((JsonObject)json, (String)"nutrientsCost", (int)1);
            return new DecomposingRecipe(recipeId, results, ingredientStack, time, cost);
        }

        public DecomposingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            IngredientStack ingredientStack = IngredientStack.fromNetwork(buffer);
            int craftingTime = buffer.m_130242_();
            int craftingCost = buffer.m_130242_();
            int outputCount = buffer.m_130242_();
            ArrayList<VariableOutput> outputs = new ArrayList<VariableOutput>();
            for (int j = 0; j < outputCount; ++j) {
                outputs.add(VariableOutput.fromNetwork(buffer));
            }
            return new DecomposingRecipe(recipeId, outputs, ingredientStack, craftingTime, craftingCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, DecomposingRecipe recipe) {
            recipe.ingredientStack.toNetwork(buffer);
            buffer.m_130130_(recipe.craftingTimeTicks);
            buffer.m_130130_(recipe.craftingCostNutrients);
            buffer.m_130130_(recipe.outputs.size());
            for (VariableOutput output : recipe.outputs) {
                output.toNetwork(buffer);
            }
        }
    }
}

