/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.datagen.recipes.builder.ItemData;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeBuilder;
import com.github.elenterius.biomancy.init.ModBioForgeTabs;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.menu.BioForgeTab;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.Nullable;

public final class BioForgingRecipeBuilder
implements RecipeBuilder<BioForgingRecipeBuilder> {
    public static final String RECIPE_SUB_FOLDER = ModRecipes.BIO_FORGING_RECIPE_TYPE.getId().m_135815_();
    private final ResourceLocation recipeId;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final ItemData result;
    private final List<IngredientStack> ingredients = new ArrayList<IngredientStack>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private BioForgeTab category = (BioForgeTab)ModBioForgeTabs.MISC.get();
    private int craftingCostNutrients = -1;

    private BioForgingRecipeBuilder(ResourceLocation recipeId, ItemData result) {
        this.recipeId = new ResourceLocation(recipeId.m_135827_(), RECIPE_SUB_FOLDER + "/" + recipeId.m_135815_());
        this.result = result;
    }

    public static BioForgingRecipeBuilder create(ResourceLocation recipeId, ItemData result) {
        return new BioForgingRecipeBuilder(recipeId, result);
    }

    public static BioForgingRecipeBuilder create(String modId, String outputName, ItemData result) {
        ResourceLocation rl = new ResourceLocation(modId, outputName);
        return new BioForgingRecipeBuilder(rl, result);
    }

    public static BioForgingRecipeBuilder create(String outputName, ItemData result) {
        ResourceLocation rl = BiomancyMod.createRL(outputName);
        return new BioForgingRecipeBuilder(rl, result);
    }

    public static BioForgingRecipeBuilder create(ItemData result) {
        ResourceLocation rl = BiomancyMod.createRL(result.getItemPath());
        return new BioForgingRecipeBuilder(rl, result);
    }

    public static BioForgingRecipeBuilder create(ItemStack stack) {
        return BioForgingRecipeBuilder.create(new ItemData(stack));
    }

    public static BioForgingRecipeBuilder create(ItemLike item) {
        return BioForgingRecipeBuilder.create(new ItemData(item));
    }

    public static BioForgingRecipeBuilder create(ItemLike item, int count) {
        return BioForgingRecipeBuilder.create(new ItemData(item, count));
    }

    public BioForgingRecipeBuilder setCraftingCost(int costNutrients) {
        if (costNutrients < 0) {
            throw new IllegalArgumentException("Invalid crafting cost: " + costNutrients);
        }
        this.craftingCostNutrients = costNutrients;
        return this;
    }

    public BioForgingRecipeBuilder ifModLoaded(String modId) {
        return this.withCondition((ICondition)new ModLoadedCondition(modId));
    }

    public BioForgingRecipeBuilder ifModMissing(String modId) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modId)));
    }

    public BioForgingRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public BioForgingRecipeBuilder setCategory(BioForgeTab category) {
        this.category = category;
        return this;
    }

    public BioForgingRecipeBuilder setCategory(Supplier<BioForgeTab> category) {
        this.category = category.get();
        return this;
    }

    public BioForgingRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public BioForgingRecipeBuilder addIngredient(TagKey<Item> tag, int quantity) {
        return this.addIngredient(Ingredient.m_204132_(tag), quantity);
    }

    public BioForgingRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public BioForgingRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public BioForgingRecipeBuilder addIngredient(ItemLike item, int quantity) {
        this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), quantity);
        return this;
    }

    public BioForgingRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        this.ingredients.add(new IngredientStack(ingredient, quantity));
        return this;
    }

    @Override
    public BioForgingRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(name, criterionTrigger);
        return this;
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, @Nullable RecipeCategory category) {
        this.validateCriteria();
        if (this.craftingCostNutrients < 0) {
            this.craftingCostNutrients = 1;
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        String folderName = RecipeBuilder.getRecipeFolderName(category, "biomancy");
        ResourceLocation advancementId = new ResourceLocation(this.recipeId.m_135827_(), "recipes/%s/%s".formatted(folderName, this.recipeId.m_135815_()));
        consumer.accept(new Result(this, advancementId));
    }

    private void validateCriteria() {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe %s because Criteria are empty.".formatted(this.recipeId));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<IngredientStack> ingredients;
        private final ItemData result;
        private final int craftingCost;
        private final BioForgeTab category;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(BioForgingRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = builder.recipeId;
            this.category = builder.category;
            this.result = builder.result;
            this.ingredients = builder.ingredients;
            this.craftingCost = builder.craftingCostNutrients;
            this.conditions = builder.conditions;
            this.advancementBuilder = builder.advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonArray = new JsonArray();
            for (IngredientStack ingredient : this.ingredients) {
                jsonArray.add((JsonElement)ingredient.toJson());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            json.add("result", (JsonElement)this.result.toJson());
            this.category.toJson(json);
            json.addProperty("nutrientsCost", (Number)this.craftingCost);
            if (!this.conditions.isEmpty()) {
                JsonArray array = new JsonArray();
                this.conditions.forEach(c -> array.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)array);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.BIO_FORGING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            if (this.conditions.isEmpty()) {
                return this.advancementBuilder.m_138400_();
            }
            ConditionalAdvancement.Builder conditionalBuilder = ConditionalAdvancement.builder();
            this.conditions.forEach(arg_0 -> ((ConditionalAdvancement.Builder)conditionalBuilder).addCondition(arg_0));
            conditionalBuilder.addAdvancement(this.advancementBuilder);
            return conditionalBuilder.write();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

