/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemData {
    private final ResourceLocation registryName;
    private final int count;
    @Nullable
    private final CompoundTag tag;

    public ItemData(ItemStack stack) {
        this(stack, stack.m_41613_());
    }

    public ItemData(ItemLike item) {
        this(item, 1);
    }

    public ItemData(ItemStack stack, int count) {
        this((ItemLike)stack.m_41720_(), stack.m_41783_(), count);
    }

    public ItemData(ItemLike item, int count) {
        this(item, null, count);
    }

    public ItemData(ItemLike item, @Nullable CompoundTag tag, int count) {
        this.registryName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
        this.tag = tag;
        this.count = count;
    }

    public static ItemData from(String namespace, String path) {
        return new ItemData(new ResourceLocation(namespace, path));
    }

    public ItemData(ResourceLocation registryName) {
        this(registryName, null, 1);
    }

    public ItemData(ResourceLocation registryName, @Nullable CompoundTag tag, int count) {
        this.registryName = registryName;
        this.tag = tag;
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.registryName.toString());
        if (this.count > 1) {
            json.addProperty("count", (Number)this.count);
        }
        if (this.tag != null && !this.tag.m_128456_()) {
            json.addProperty("nbt", this.tag.m_7916_());
        }
        return json;
    }

    public String getItemPath() {
        return this.registryName.m_135815_();
    }
}

