/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;

public interface ControllableMob<T extends Mob> {
    public static <T extends Mob> ControllableMob<T> cast(T mob) {
        return (ControllableMob)mob;
    }

    private T getMobInstance() {
        return (T)((Mob)this);
    }

    default public boolean canExecuteCommand() {
        return this.getActiveCommand() != Command.SIT;
    }

    public Command getActiveCommand();

    public void setActiveCommand(Command var1);

    default public void updateRestriction(Command cmd) {
        this.updateRestriction(cmd, this.getMobInstance().m_20183_());
    }

    default public void updateRestriction(Command cmd, BlockPos pos) {
        T mob = this.getMobInstance();
        if (cmd == Command.SIT) {
            mob.m_21446_(pos, 4);
        } else if (cmd == Command.PATROL_AREA) {
            mob.m_21446_(pos, 24);
        } else if (cmd == Command.HOLD_POSITION) {
            mob.m_21446_(pos, 8);
        } else {
            mob.m_147271_();
        }
    }

    default public Action getCurrentAction() {
        return Action.IDLE;
    }

    public static enum Command {
        SIT,
        HOLD_POSITION,
        DEFEND_OWNER,
        PATROL_AREA,
        SEEK_AND_DESTROY;


        public static Command deserialize(byte b) {
            for (Command value : Command.values()) {
                if (value.ordinal() != b) continue;
                return value;
            }
            return SIT;
        }

        public Command cycle() {
            return Command.deserialize((byte)(this.ordinal() + 1));
        }

        public byte serialize() {
            return (byte)this.ordinal();
        }
    }

    public static enum Action {
        IDLE,
        ATTACKING_WITH_MELEE_WEAPON,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE;

    }
}

