/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.event;

import com.github.elenterius.biomancy.world.MobSpawnFilter;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeManager;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MobSpawnHandler {
    private MobSpawnHandler() {
    }

    public static void onCheckSpawn(MobSpawnEvent.PositionCheck event) {
        if (event.isCanceled()) {
            return;
        }
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            MobSpawnType spawnReason = event.getSpawnType();
            if (MobSpawnFilter.isNaturalSpawn(spawnReason)) {
                double z;
                double y;
                double x;
                Predicate<Shape> denySpawnPredicate;
                boolean denySpawn;
                Mob mob = event.getEntity();
                boolean bl = denySpawn = SpatialShapeManager.getAnyShape(serverLevel, (Entity)mob, SpatialShapeManager.QueryStrategy.INTERSECTION, denySpawnPredicate = arg_0 -> MobSpawnHandler.lambda$onCheckSpawn$0(mob, spawnReason, serverLevel, x = event.getX(), y = event.getY(), z = event.getZ(), arg_0)) != null;
                if (denySpawn) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private static /* synthetic */ boolean lambda$onCheckSpawn$0(Mob mob, MobSpawnType spawnReason, ServerLevel serverLevel, double x, double y, double z, Shape shape) {
        MobSpawnFilter filter;
        return shape instanceof MobSpawnFilter && !(filter = (MobSpawnFilter)((Object)shape)).isMobAllowedToSpawn(mob, spawnReason, (LevelAccessor)serverLevel, x, y, z);
    }
}

