/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.event;

import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.block.vialholder.VialHolderBlock;
import com.github.elenterius.biomancy.item.ChrysalisBlockItem;
import com.github.elenterius.biomancy.item.extractor.ExtractorItem;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class PlayerInteractHandler {
    private PlayerInteractHandler() {
    }

    @SubscribeEvent
    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof ExtractorItem || item instanceof InjectorItem || item instanceof ChrysalisBlockItem) {
            Entity target = event.getTarget();
            if (target instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)target;
                PlayerInteractHandler.interactWithParent(event, stack, item, partEntity);
            } else if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                PlayerInteractHandler.bypassLivingInteraction(event, stack, item, livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_41720_() instanceof SerumContainer && event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof VialHolderBlock) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    private static void interactWithParent(PlayerInteractEvent.EntityInteract event, ItemStack stack, Item item, PartEntity<?> partEntity) {
        Entity parent = PlayerInteractHandler.getParent(partEntity);
        if (parent instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)parent;
            InteractionResult interactionResult = item.m_6880_(stack, event.getEntity(), livingEntity, event.getHand());
            event.setCancellationResult(interactionResult);
            event.setCanceled(true);
        }
    }

    private static void bypassLivingInteraction(PlayerInteractEvent.EntityInteract event, ItemStack stack, Item item, LivingEntity livingEntity) {
        InteractionResult interactionResult = item.m_6880_(stack, event.getEntity(), livingEntity, event.getHand());
        event.setCancellationResult(interactionResult);
        event.setCanceled(true);
    }

    private static Entity getParent(Entity entity) {
        if (entity instanceof PartEntity) {
            PartEntity partEntity = (PartEntity)entity;
            return PlayerInteractHandler.getParent(partEntity.getParent());
        }
        return entity;
    }
}

