/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public enum ModArmorMaterials implements ArmorMaterial
{
    ACOLYTE(BiomancyMod.createRLString("acolyte"), 1, new int[]{2, 6, 5, 2}, 0.25f, 0.1f, 0, () -> Ingredient.f_43901_, () -> SoundEvents.f_11680_),
    OVERSEER(BiomancyMod.createRLString("overseer"), 1, new int[]{2, 6, 5, 2}, 0.25f, 0.0f, 0, () -> Ingredient.f_43901_, () -> SoundEvents.f_11680_);

    private static final int[] BASE_DURABILITY;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] defense;
    private final float toughness;
    private final float knockbackResistance;
    private final int enchantability;
    private final Supplier<Ingredient> repairMaterial;
    private final Supplier<SoundEvent> equipSound;

    private ModArmorMaterials(String name, int durabilityMultiplier, int[] defense, float toughness, float knockbackResistance, int enchantability, Supplier<Ingredient> repairMaterial, Supplier<SoundEvent> equipSound) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.defense = defense;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = Suppliers.memoize(repairMaterial::get);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound.get();
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public int m_266425_(ArmorItem.Type type) {
        return BASE_DURABILITY[type.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.defense[type.ordinal()];
    }

    static {
        BASE_DURABILITY = new int[]{11, 16, 15, 13};
    }
}

