/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.block.base.BlockEntityDelegator;
import com.github.elenterius.biomancy.block.bioforge.BioForgeBlockEntity;
import com.github.elenterius.biomancy.block.biolab.BioLabBlockEntity;
import com.github.elenterius.biomancy.block.chrysalis.ChrysalisBlockEntity;
import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlockEntity;
import com.github.elenterius.biomancy.block.decomposer.DecomposerBlockEntity;
import com.github.elenterius.biomancy.block.digester.DigesterBlockEntity;
import com.github.elenterius.biomancy.block.fleshkinchest.FleshkinChestBlockEntity;
import com.github.elenterius.biomancy.block.mawhopper.MawHopperBlockEntity;
import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlockEntity;
import com.github.elenterius.biomancy.block.modularlarynx.ModularLarynxBlockEntity;
import com.github.elenterius.biomancy.block.ownable.OwnableBlockEntity;
import com.github.elenterius.biomancy.block.storagesac.StorageSacBlockEntity;
import com.github.elenterius.biomancy.block.tongue.TongueBlockEntity;
import com.github.elenterius.biomancy.block.vialholder.VialHolderBlockEntity;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.mojang.datafixers.types.Type;
import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"biomancy");
    public static final RegistryObject<BlockEntityType<PrimordialCradleBlockEntity>> PRIMORDIAL_CRADLE = ModBlockEntities.register(ModBlocks.PRIMORDIAL_CRADLE, PrimordialCradleBlockEntity::new);
    public static final RegistryObject<BlockEntityType<DecomposerBlockEntity>> DECOMPOSER = ModBlockEntities.register(ModBlocks.DECOMPOSER, DecomposerBlockEntity::new);
    public static final RegistryObject<BlockEntityType<BioForgeBlockEntity>> BIO_FORGE = ModBlockEntities.register(ModBlocks.BIO_FORGE, BioForgeBlockEntity::new);
    public static final RegistryObject<BlockEntityType<BioLabBlockEntity>> BIO_LAB = ModBlockEntities.register(ModBlocks.BIO_LAB, BioLabBlockEntity::new);
    public static final RegistryObject<BlockEntityType<DigesterBlockEntity>> DIGESTER = ModBlockEntities.register(ModBlocks.DIGESTER, DigesterBlockEntity::new);
    public static final RegistryObject<BlockEntityType<TongueBlockEntity>> TONGUE = ModBlockEntities.register(ModBlocks.TONGUE, TongueBlockEntity::new);
    public static final RegistryObject<BlockEntityType<MawHopperBlockEntity>> MAW_HOPPER = ModBlockEntities.register(ModBlocks.MAW_HOPPER, MawHopperBlockEntity::new);
    public static final RegistryObject<BlockEntityType<StorageSacBlockEntity>> STORAGE_SAC = ModBlockEntities.register(ModBlocks.STORAGE_SAC, StorageSacBlockEntity::new);
    public static final RegistryObject<BlockEntityType<FleshkinChestBlockEntity>> FLESHKIN_CHEST = ModBlockEntities.register(ModBlocks.FLESHKIN_CHEST, FleshkinChestBlockEntity::new);
    public static final RegistryObject<BlockEntityType<VialHolderBlockEntity>> VIAL_HOLDER = ModBlockEntities.register(ModBlocks.VIAL_HOLDER, VialHolderBlockEntity::new);
    public static final RegistryObject<BlockEntityType<ModularLarynxBlockEntity>> MODULAR_LARYNX = ModBlockEntities.register(ModBlocks.MODULAR_LARYNX, ModularLarynxBlockEntity::new);
    public static final RegistryObject<BlockEntityType<ChrysalisBlockEntity>> CHRYSALIS = ModBlockEntities.register(ModBlocks.CHRYSALIS, ChrysalisBlockEntity::new);
    public static final RegistryObject<BlockEntityType<BiometricMembraneBlockEntity>> BIOMETRIC_MEMBRANE = ModBlockEntities.register(ModBlocks.BIOMETRIC_MEMBRANE, BiometricMembraneBlockEntity::new);
    public static final RegistryObject<BlockEntityType<OwnableBlockEntity>> OWNABLE_BE = BLOCK_ENTITIES.register("ownable_block_entity", () -> BlockEntityType.Builder.m_155273_(OwnableBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.FLESHKIN_PRESSURE_PLATE.get()}).m_58966_(ModBlockEntities.noDataFixer()));
    public static final RegistryObject<BlockEntityType<BlockEntityDelegator>> BE_DELEGATOR = BLOCK_ENTITIES.register("block_entity_delegator", () -> BlockEntityType.Builder.m_155273_(BlockEntityDelegator::new, (Block[])new Block[]{Blocks.f_50016_}).m_58966_(ModBlockEntities.noDataFixer()));

    private ModBlockEntities() {
    }

    private static <T extends BlockEntity, B extends Block> RegistryObject<BlockEntityType<T>> register(RegistryObject<B> blockHolder, BlockEntityType.BlockEntitySupplier<T> factory) {
        return BLOCK_ENTITIES.register(blockHolder.getId().m_135815_(), () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])new Block[]{(Block)blockHolder.get()}).m_58966_(ModBlockEntities.noDataFixer()));
    }

    @SafeVarargs
    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, RegistryObject<? extends Block> ... blockHolders) {
        return BLOCK_ENTITIES.register(name, () -> {
            Block[] blocks = Arrays.stream(blockHolders).map(RegistryObject::get).toList().toArray(new Block[0]);
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])blocks).m_58966_(ModBlockEntities.noDataFixer());
        });
    }

    private static Type<?> noDataFixer() {
        return null;
    }
}

