/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.fluid.AcidFluid;
import com.github.elenterius.biomancy.fluid.TintedFluidType;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModItems;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"biomancy");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"biomancy");
    public static final RegistryObject<TintedFluidType> ACID_TYPE = ModFluids.registerTintedType("acid", -12976364, properties -> properties.density(1024).viscosity(1024));
    public static final Supplier<ForgeFlowingFluid.Properties> ACID_FLUID_PROPERTIES = () -> new ForgeFlowingFluid.Properties(ACID_TYPE, ACID, FLOWING_ACID).slopeFindDistance(2).levelDecreasePerBlock(2).block(ModBlocks.ACID_FLUID_BLOCK).bucket(ModItems.ACID_BUCKET);
    public static final RegistryObject<ForgeFlowingFluid> ACID = ModFluids.register("acid", () -> new AcidFluid.Source(ACID_FLUID_PROPERTIES.get()));
    public static final RegistryObject<ForgeFlowingFluid> FLOWING_ACID = ModFluids.register("flowing_acid", () -> new AcidFluid.Flowing(ACID_FLUID_PROPERTIES.get()));

    private ModFluids() {
    }

    static void registerInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ACID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> fluidState.m_76170_() ? Blocks.f_152497_.m_49966_() : Blocks.f_50228_.m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ACID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : Blocks.f_50228_.m_49966_()));
    }

    private static <T extends Fluid> RegistryObject<T> register(String name, Supplier<T> factory) {
        return FLUIDS.register(name, factory);
    }

    private static RegistryObject<TintedFluidType> registerTintedType(String name, int colorARGB, UnaryOperator<FluidType.Properties> operator) {
        return FLUID_TYPES.register(name, () -> new TintedFluidType((FluidType.Properties)operator.apply(ModFluids.createFluidTypeProperties()), colorARGB));
    }

    private static RegistryObject<FluidType> registerType(final String name, UnaryOperator<FluidType.Properties> operator) {
        return FLUID_TYPES.register(name, () -> new FluidType((FluidType.Properties)operator.apply(ModFluids.createFluidTypeProperties())){
            private final ResourceLocation stillTexture;
            private final ResourceLocation flowingTexture;
            private final ResourceLocation overlayTexture;
            {
                super(properties);
                this.stillTexture = BiomancyMod.createRL("fluid/%s_still".formatted(name));
                this.flowingTexture = BiomancyMod.createRL("fluid/%s_flowing".formatted(name));
                this.overlayTexture = BiomancyMod.createRL("fluid/%s_overlay".formatted(name));
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return flowingTexture;
                    }

                    public ResourceLocation getOverlayTexture() {
                        return overlayTexture;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return overlayTexture;
                    }
                });
            }
        });
    }

    private static FluidType.Properties createFluidTypeProperties() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }
}

