/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.init.ModMobEffects;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModPotions {
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"biomancy");
    public static final RegistryObject<Potion> GASTRIC_JUICE = ModPotions.register("gastric_juice", () -> new MobEffectInstance[]{new MobEffectInstance((MobEffect)ModMobEffects.CORROSIVE.get(), 80, 0), new MobEffectInstance((MobEffect)ModMobEffects.ARMOR_SHRED.get(), 140, 0)});
    public static final RegistryObject<Potion> PRIMORDIAL_INFESTATION = ModPotions.register("primordial_infestation", () -> new MobEffectInstance[]{new MobEffectInstance((MobEffect)ModMobEffects.PRIMORDIAL_INFESTATION.get(), 1800, 0)});
    public static final RegistryObject<Potion> LONG_PRIMORDIAL_INFESTATION = ModPotions.register("primordial_infestation", PotionVariant.LONG, () -> new MobEffectInstance[]{new MobEffectInstance((MobEffect)ModMobEffects.PRIMORDIAL_INFESTATION.get(), 4800, 0)});

    private ModPotions() {
    }

    private static RegistryObject<Potion> register(String name, Supplier<MobEffectInstance[]> effects) {
        String translationKey = "biomancy." + name;
        return POTIONS.register(name, () -> new Potion(translationKey, (MobEffectInstance[])effects.get()));
    }

    private static RegistryObject<Potion> register(String name, PotionVariant variant, Supplier<MobEffectInstance[]> effects) {
        String key = variant.name().toLowerCase(Locale.ENGLISH) + "_" + name;
        String translationKey = "biomancy." + name;
        return POTIONS.register(key, () -> new Potion(translationKey, (MobEffectInstance[])effects.get()));
    }

    private static enum PotionVariant {
        LONG,
        STRONG;

    }
}

