/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init.client;

import com.github.elenterius.biomancy.BiomancyMod;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ModRenderTypes {
    @Nullable
    private static ShaderInstance entityCutoutPartyTimeShader;

    private ModRenderTypes() {
    }

    @SubscribeEvent
    public static void onClientSetup(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), BiomancyMod.createRL("entity_cutout_party_time"), DefaultVertexFormat.f_85812_), instance -> {
            entityCutoutPartyTimeShader = instance;
        });
    }

    public static RenderType getCutoutPartyTime(ResourceLocation textureLocation) {
        return ModRenderType.ENTITY_CUTOUT_PARTY_TIME.apply(textureLocation);
    }

    public static ShaderInstance getEntityCutoutPartyTimeShader() {
        return Objects.requireNonNull(entityCutoutPartyTimeShader, "Attempted to call getEntityCutoutPartyTimeShader before shaders have finished loading.");
    }

    private static final class ModRenderType
    extends RenderType {
        private static final RenderStateShard.ShaderStateShard RENDER_TYPE_ENTITY_CUTOUT_PARTY_TIME_SHADER = new RenderStateShard.ShaderStateShard(ModRenderTypes::getEntityCutoutPartyTimeShader);
        private static final Function<ResourceLocation, RenderType> ENTITY_CUTOUT_PARTY_TIME = Util.m_143827_(tex -> {
            RenderType.CompositeState renderState = RenderType.CompositeState.m_110628_().m_173292_(RENDER_TYPE_ENTITY_CUTOUT_PARTY_TIME_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(tex, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
            return ModRenderType.m_173215_((String)"biomancy_entity_cutout_party_time", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)renderState);
        });

        private ModRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }
}

