/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.BioBrewingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BioBrewingCategory
implements IRecipeCategory<BioBrewingRecipe> {
    public static final RecipeType<BioBrewingRecipe> RECIPE_TYPE = new RecipeType(ModRecipes.BIO_BREWING_RECIPE_TYPE.getId(), BioBrewingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final RecipeWrapper inputInventoryWrapper;

    public BioBrewingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.BIO_LAB.get()));
        ResourceLocation texture = BiomancyMod.createRL("textures/gui/jei/bio_lab_recipe.png");
        this.background = guiHelper.drawableBuilder(texture, 0, 0, 134, 54).setTextureSize(134, 54).addPadding(0, 4, 0, 0).build();
        this.inputInventoryWrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(5));
    }

    public RecipeType<BioBrewingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return ComponentUtil.translatable("jei.biomancy.recipe.bio_lab");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BioBrewingRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        builder.setShapeless();
        List<IngredientStack> ingredientQuantities = recipe.getIngredientQuantities();
        this.addInputSlot(builder, 1, 1, ingredientQuantities, 0);
        this.addInputSlot(builder, 19, 1, ingredientQuantities, 1);
        this.addInputSlot(builder, 1, 19, ingredientQuantities, 2);
        this.addInputSlot(builder, 19, 19, ingredientQuantities, 3);
        builder.addSlot(RecipeIngredientRole.INPUT, 55, 10).addIngredients(recipe.getReactant());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 10).addItemStack(recipe.m_8043_(level.m_9598_()));
    }

    private void addInputSlot(IRecipeLayoutBuilder builder, int x, int y, List<IngredientStack> ingredients, int index) {
        assert (index >= 0);
        assert (index < 4);
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x, y);
        if (index < ingredients.size()) {
            slotBuilder.addItemStacks(ingredients.get(index).getItemsWithCount());
        }
    }

    public void draw(BioBrewingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        List slotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
        for (int i = 0; i < slotViews.size(); ++i) {
            IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(i);
            ItemStack itemStack = slotView.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            this.inputInventoryWrapper.m_6836_(i, itemStack);
        }
        int ticks = recipe.getCraftingTimeTicks((Container)this.inputInventoryWrapper);
        int seconds = ticks > 0 ? ticks / 20 : 0;
        MutableComponent timeText = ComponentUtil.translatable("gui.jei.category.smelting.time.seconds", seconds);
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)timeText, 102, 50 - 9, -1);
        MutableComponent costText = ComponentUtil.literal("-" + recipe.getCraftingCostNutrients((Container)this.inputInventoryWrapper));
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)costText, 69, 50 - 9, -1);
    }
}

