/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.ItemCountRange;
import com.github.elenterius.biomancy.crafting.VariableOutput;
import com.github.elenterius.biomancy.crafting.recipe.DecomposingRecipe;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DecomposingCategory
implements IRecipeCategory<DecomposingRecipe> {
    public static final RecipeType<DecomposingRecipe> RECIPE_TYPE = new RecipeType(ModRecipes.DECOMPOSING_RECIPE_TYPE.getId(), DecomposingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final RecipeWrapper inputInventoryWrapper;

    public DecomposingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.DECOMPOSER.get()));
        this.background = guiHelper.drawableBuilder(BiomancyMod.createRL("textures/gui/jei/decomposer_recipe.png"), 0, 0, 128, 64).setTextureSize(128, 64).build();
        this.inputInventoryWrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    }

    public RecipeType<DecomposingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return ComponentUtil.translatable("jei.biomancy.recipe.decomposer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private void addOutputSlot(IRecipeLayoutBuilder builder, int x, int y, List<VariableOutput> outputs, int index) {
        assert (index >= 0);
        assert (index < 6);
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, x, y);
        if (index < outputs.size()) {
            VariableOutput output = outputs.get(index);
            ItemStack stack = output.getItemStack();
            slotBuilder.addItemStack(stack);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DecomposingRecipe recipe, IFocusGroup focuses) {
        int x = 51;
        int y0 = 9;
        int y1 = 38;
        builder.addSlot(RecipeIngredientRole.INPUT, 5, y0).addItemStacks(recipe.getIngredientQuantity().getItemsWithCount());
        List<VariableOutput> outputs = recipe.getOutputs();
        this.addOutputSlot(builder, x, y0, outputs, 0);
        this.addOutputSlot(builder, x, y1, outputs, 1);
        this.addOutputSlot(builder, x + 30, y0, outputs, 2);
        this.addOutputSlot(builder, x + 30, y1, outputs, 3);
        this.addOutputSlot(builder, x + 60, y0, outputs, 4);
        this.addOutputSlot(builder, x + 60, y1, outputs, 5);
    }

    public void draw(DecomposingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        IRecipeSlotView slotView = (IRecipeSlotView)recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).get(0);
        ItemStack itemStack = slotView.getDisplayedItemStack().orElse(ItemStack.f_41583_);
        this.inputInventoryWrapper.m_6836_(0, itemStack);
        int ticks = recipe.getCraftingTimeTicks((Container)this.inputInventoryWrapper);
        int seconds = ticks > 0 ? ticks / 20 : 0;
        MutableComponent timeString = ComponentUtil.translatable("gui.jei.category.smelting.time.seconds", seconds);
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)timeString, 16, 59 - 9, -1);
        MutableComponent costString = ComponentUtil.literal("-" + recipe.getCraftingCostNutrients((Container)this.inputInventoryWrapper));
        Objects.requireNonNull(font);
        guiGraphics.m_280430_(font, (Component)costString, 16, 43 - 9, -1);
        int x = 68;
        List<VariableOutput> outputs = recipe.getOutputs();
        this.drawOutputAmount(font, guiGraphics, x, 26, outputs, 0);
        this.drawOutputAmount(font, guiGraphics, x, 55, outputs, 1);
        this.drawOutputAmount(font, guiGraphics, x + 30, 26, outputs, 2);
        this.drawOutputAmount(font, guiGraphics, x + 30, 55, outputs, 3);
        this.drawOutputAmount(font, guiGraphics, x + 60, 26, outputs, 4);
        this.drawOutputAmount(font, guiGraphics, x + 60, 55, outputs, 5);
    }

    private void drawOutputAmount(Font font, GuiGraphics guiGraphics, int x, int y, List<VariableOutput> outputs, int index) {
        assert (index >= 0);
        assert (index < 6);
        if (index < outputs.size()) {
            VariableOutput output = outputs.get(index);
            if (output.getItemStack().m_41619_()) {
                return;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            guiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
            guiGraphics.m_280168_().m_252880_((float)(-x), (float)(-y), 0.0f);
            ItemCountRange countRange = output.getCountRange();
            if (countRange instanceof ItemCountRange.UniformRange) {
                ItemCountRange.UniformRange uniform = (ItemCountRange.UniformRange)countRange;
                MutableComponent component = ComponentUtil.literal("%d\u2013%d".formatted(uniform.min(), uniform.max()));
                guiGraphics.m_280430_(font, (Component)component, x - font.m_92852_((FormattedText)component), y, -1);
            } else if (countRange instanceof ItemCountRange.ConstantValue) {
                ItemCountRange.ConstantValue constant = (ItemCountRange.ConstantValue)countRange;
                MutableComponent component = ComponentUtil.literal("" + constant.value());
                guiGraphics.m_280430_(font, (Component)component, x - font.m_92852_((FormattedText)component), y, -1);
            } else if (countRange instanceof ItemCountRange.BinomialRange) {
                ItemCountRange.BinomialRange binomialRange = (ItemCountRange.BinomialRange)countRange;
                MutableComponent component = ComponentUtil.literal("n=%d p=%s".formatted(binomialRange.n(), Float.valueOf(binomialRange.p())));
                guiGraphics.m_280430_(font, (Component)component, x - font.m_92852_((FormattedText)component), y, -1);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

