/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.inventory.BehavioralItemHandler;
import com.github.elenterius.biomancy.inventory.FixedSizeItemStackHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.inventory.Notify;
import com.github.elenterius.biomancy.inventory.SerializableItemHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public final class InventoryHandlers {
    public static final Predicate<ItemStack> EMPTY_ITEM_INVENTORY_PREDICATE = stack -> {
        if (stack.m_41720_() instanceof BundleItem) {
            return false;
        }
        if (!stack.m_41720_().m_142095_()) {
            return false;
        }
        LazyOptional capability = stack.getCapability(ModCapabilities.ITEM_HANDLER);
        boolean[] isEmpty = new boolean[]{true};
        capability.ifPresent(itemHandler -> {
            int slots = itemHandler.getSlots();
            if (slots > 200) {
                isEmpty[0] = false;
                return;
            }
            for (int i = 0; i < slots; ++i) {
                if (itemHandler.getStackInSlot(i).m_41619_()) continue;
                isEmpty[0] = false;
                break;
            }
        });
        return isEmpty[0];
    };

    private InventoryHandlers() {
    }

    public static InventoryHandler<FixedSizeItemStackHandler> standard(int slotAmount) {
        return new InventoryHandler<FixedSizeItemStackHandler>(new FixedSizeItemStackHandler(slotAmount));
    }

    public static InventoryHandler<FixedSizeItemStackHandler> standard(int slotAmount, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return new InventoryHandler<FixedSizeItemStackHandler>(handler);
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.DenyInput> denyInput(T itemStackHandler) {
        return new InventoryHandler<BehavioralItemHandler.DenyInput>(new BehavioralItemHandler.DenyInput(itemStackHandler));
    }

    public static InventoryHandler<BehavioralItemHandler.DenyInput> denyInput(int slotAmount, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return new InventoryHandler<BehavioralItemHandler.DenyInput>(new BehavioralItemHandler.DenyInput(handler));
    }

    public static InventoryHandler<BehavioralItemHandler.PredicateFilterInput> filterInput(int slotAmount, List<Predicate<ItemStack>> slotFilters) {
        return InventoryHandlers.filterInput(new FixedSizeItemStackHandler(slotAmount), slotFilters);
    }

    public static InventoryHandler<BehavioralItemHandler.PredicateFilterInput> filterInput(int slotAmount, List<Predicate<ItemStack>> slotFilters, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return InventoryHandlers.filterInput(handler, slotFilters);
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.PredicateFilterInput> filterInput(T itemStackHandler, List<Predicate<ItemStack>> slotFilters) {
        return new InventoryHandler<BehavioralItemHandler.PredicateFilterInput>(new BehavioralItemHandler.PredicateFilterInput(itemStackHandler, slotFilters));
    }

    public static InventoryHandler<BehavioralItemHandler.ItemStackFilterInput> filterInput(int slotAmount) {
        return InventoryHandlers.filterInput(new FixedSizeItemStackHandler(slotAmount));
    }

    public static InventoryHandler<BehavioralItemHandler.ItemStackFilterInput> filterInput(int slotAmount, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return InventoryHandlers.filterInput(handler);
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.ItemStackFilterInput> filterInput(T itemStackHandler) {
        return new InventoryHandler<BehavioralItemHandler.ItemStackFilterInput>(new BehavioralItemHandler.ItemStackFilterInput(itemStackHandler));
    }

    public static InventoryHandler<BehavioralItemHandler.LockableItemStackFilterInput> lockableFilterInput(int slotAmount, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return InventoryHandlers.lockableFilterInput(handler);
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.LockableItemStackFilterInput> lockableFilterInput(T itemStackHandler) {
        return new InventoryHandler<BehavioralItemHandler.LockableItemStackFilterInput>(new BehavioralItemHandler.LockableItemStackFilterInput(itemStackHandler));
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.PredicateFilterInput> denyItemWithFilledInventory(T itemHandler) {
        return new InventoryHandler<BehavioralItemHandler.PredicateFilterInput>(new BehavioralItemHandler.PredicateFilterInput(itemHandler, IntStream.range(0, itemHandler.getSlots()).mapToObj(x -> EMPTY_ITEM_INVENTORY_PREDICATE).toList()));
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.PredicateFilterInput> denyItemWithFilledInventory(int slotAmount, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return InventoryHandlers.denyItemWithFilledInventory(handler);
    }

    public static InventoryHandler<BehavioralItemHandler.PredicateFilterInput> filterFuel(int slotAmount) {
        return InventoryHandlers.filterFuel(new FixedSizeItemStackHandler(slotAmount));
    }

    public static InventoryHandler<BehavioralItemHandler.PredicateFilterInput> filterFuel(int slotAmount, final Notify onInventoryChanged) {
        FixedSizeItemStackHandler handler = new FixedSizeItemStackHandler(slotAmount){

            protected void onContentsChanged(int slot) {
                onInventoryChanged.invoke();
            }
        };
        return InventoryHandlers.filterFuel(handler);
    }

    public static <T extends SerializableItemHandler> InventoryHandler<BehavioralItemHandler.PredicateFilterInput> filterFuel(T itemHandler) {
        return InventoryHandlers.filterInput(itemHandler, IntStream.range(0, itemHandler.getSlots()).mapToObj(x -> Nutrients.FUEL_PREDICATE).toList());
    }
}

