/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.armor;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class AcolyteArmorUpgrades {
    private static final List<Upgrade> UPGRADES = new ArrayList<Upgrade>();
    public static final Upgrade PRIMORDIAL_SIGHT = AcolyteArmorUpgrades.register("primordial_sight");

    private AcolyteArmorUpgrades() {
    }

    public static Upgrade register(ResourceLocation name) {
        Upgrade upgrade = new Upgrade(name);
        UPGRADES.add(upgrade);
        return upgrade;
    }

    private static Upgrade register(String name) {
        Upgrade upgrade = new Upgrade(BiomancyMod.createRL(name));
        UPGRADES.add(upgrade);
        return upgrade;
    }

    public static ItemStack addUpgrade(ItemStack stack, Upgrade upgrade) {
        if (stack.m_150930_((Item)ModItems.ACOLYTE_ARMOR_HELMET.get())) {
            stack.m_41784_().m_128379_(upgrade.id.toString(), true);
        }
        return stack;
    }

    public static boolean hasUpgrade(ItemStack stack, Upgrade upgrade) {
        if (stack.m_150930_((Item)ModItems.ACOLYTE_ARMOR_HELMET.get())) {
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128441_(upgrade.id.toString());
        }
        return false;
    }

    public static void appendHoverText(ItemStack stack, List<Component> tooltip) {
        for (Upgrade upgrade : UPGRADES) {
            if (!AcolyteArmorUpgrades.hasUpgrade(stack, upgrade)) continue;
            tooltip.add(ComponentUtil.emptyLine());
            upgrade.appendHoverText(stack, tooltip);
        }
    }

    public static class Upgrade {
        private final ResourceLocation id;

        public Upgrade(ResourceLocation id) {
            this.id = id;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public void appendHoverText(ItemStack stack, List<Component> tooltip) {
            String translationKey = this.id.m_135815_();
            tooltip.add((Component)TextComponentUtil.getAbilityText(translationKey).m_130948_(TextStyles.GRAY));
            tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText(translationKey + ".desc")).m_130948_(TextStyles.DARK_GRAY));
        }
    }
}

