/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.armor;

import com.github.elenterius.biomancy.api.livingtool.SimpleLivingTool;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class LivingArmorItem
extends ArmorItem
implements SimpleLivingTool {
    private final int maxNutrients;

    public LivingArmorItem(ArmorMaterial material, ArmorItem.Type type, int maxNutrients, Item.Properties properties) {
        super(material, type, properties);
        this.maxNutrients = maxNutrients;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add(ComponentUtil.emptyLine());
        this.appendLivingToolTooltip(stack, tooltip);
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }

    @Override
    public int getMaxNutrients(ItemStack container) {
        return this.maxNutrients;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.getNutrients(stack) > 0 ? super.getAttributeModifiers(slot, stack) : ImmutableMultimap.of();
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (this.handleOverrideStackedOnOther(stack, slot, action, player)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.handleOverrideOtherStackedOnMe(stack, other, slot, action, player, access)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getNutrients(stack) < this.getMaxNutrients(stack);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(this.getNutrientsPct(stack) * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 9742422;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public boolean isDamageable(ItemStack stack) {
        return this.hasNutrients(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public int getDamage(ItemStack stack) {
        int max = this.getMaxNutrients(stack);
        return Mth.m_14045_((int)(max - this.getNutrients(stack)), (int)0, (int)max);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxNutrients(stack);
    }

    public boolean m_41465_() {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        this.decreaseNutrients(stack, amount);
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isValidEnchantment(stack, enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

