/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.shield;

import com.github.elenterius.biomancy.api.livingtool.SimpleLivingTool;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.shield.SimpleShieldItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.MobUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;

public class LivingShieldItem
extends SimpleShieldItem
implements SimpleLivingTool {
    private final int maxNutrients;

    public LivingShieldItem(int maxNutrients, Item.Properties properties) {
        super(properties);
        this.maxNutrients = maxNutrients;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        tooltip.add(ComponentUtil.emptyLine());
        this.appendLivingToolTooltip(stack, tooltip);
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }

    @Override
    public int getMaxNutrients(ItemStack stack) {
        return this.maxNutrients;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (this.handleOverrideStackedOnOther(stack, slot, action, player)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.handleOverrideOtherStackedOnMe(stack, other, slot, action, player, access)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) && this.hasNutrients(stack);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.hasNutrients(stack)) {
            if (level.m_5776_()) {
                player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_nutrients"), true);
                player.m_5496_((SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (level.m_5776_()) {
            return;
        }
        if (!this.hasNutrients(stack)) {
            livingEntity.m_5810_();
        }
    }

    public void damageCurrentlyUsedLivingShield(ItemStack usedShield, float damageAmount, LivingEntity entity) {
        if (!MobUtil.isCreativePlayer(entity)) {
            int amount = 1 + Mth.m_14143_((float)damageAmount);
            this.decreaseNutrients(usedShield, amount);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getNutrients(stack) < this.getMaxNutrients(stack);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(this.getNutrientsPct(stack) * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 9742422;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isValidEnchantment(stack, enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

