/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.Lazy;

public class ClawsItem
extends TieredItem
implements Vanishable {
    protected static final UUID BASE_ATTACK_RANGE_UUID = UUID.fromString("d76adb08-2bb3-4e88-997d-766a919f0f6b");
    protected final Lazy<Multimap<Attribute, AttributeModifier>> defaultAttributeModifiers;

    public ClawsItem(Tier tier, float baseAttackDamage, float attackSpeedModifier, float attackRangeModifier, Item.Properties properties) {
        super(tier, properties);
        float attackDamageModifier = baseAttackDamage + tier.m_6631_();
        this.defaultAttributeModifiers = Lazy.of(() -> this.createDefaultAttributeModifiers(attackDamageModifier, attackSpeedModifier, attackRangeModifier).build());
    }

    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> createDefaultAttributeModifiers(float attackDamageModifier, float attackSpeedModifier, float attackRangeModifier) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamageModifier, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ATTACK_RANGE_UUID, "Weapon modifier", (double)attackRangeModifier, AttributeModifier.Operation.ADDITION));
        return builder;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? (Multimap)this.defaultAttributeModifiers.get() : super.m_7167_(equipmentSlot);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_.m_7454_(stack.m_41720_()) || enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.getDestroySpeed(state);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, miningEntity, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState block) {
        return block.m_60713_(Blocks.f_50033_) || block.m_204336_(BlockTags.f_13035_);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.PASS;
        }
        if (this.shearInteractionTarget(stack, player, interactionTarget, usedHand)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected float getDestroySpeed(BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        if (state.m_204336_(BlockTags.f_13035_)) {
            return 15.0f;
        }
        if (state.m_204336_(BlockTags.f_13089_)) {
            return 5.0f;
        }
        return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    protected boolean shearInteractionTarget(ItemStack stack, Player player, LivingEntity targetEntity, InteractionHand usedHand) {
        if (targetEntity instanceof IForgeShearable) {
            IForgeShearable shearingTarget = (IForgeShearable)targetEntity;
            BlockPos pos = targetEntity.m_20183_();
            if (shearingTarget.isShearable(stack, targetEntity.m_9236_(), pos)) {
                List drops = shearingTarget.onSheared(player, stack, targetEntity.m_9236_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                RandomSource rand = player.m_217043_();
                drops.forEach(lootStack -> {
                    ItemEntity itemEntity = targetEntity.m_5552_(lootStack, 1.0f);
                    if (itemEntity != null) {
                        itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                    }
                });
                stack.m_41622_(1, targetEntity, entity -> entity.m_21190_(usedHand));
            }
            return true;
        }
        return false;
    }
}

