/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon.gun;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface Gun {
    public static final int ONE_SECOND_IN_TICKS = 20;
    public static final int ONE_HOUR_IN_TICKS = 72000;
    public static final float MAX_INACCURACY = 1.0f;
    public static final String AMMO_KEY = "ammo";
    public static final String RELOAD_TIMESTAMP_KEY = "reload_timestamp";
    public static final String WEAPON_STATE_KEY = "projectile_weapon_state";
    public static final String SHOOT_TIMESTAMP_KEY = "shoot_timestamp";

    default public long getShootTimestamp(ItemStack stack) {
        return stack.m_41784_().m_128454_(SHOOT_TIMESTAMP_KEY);
    }

    public void stopShooting(ItemStack var1, ServerLevel var2, LivingEntity var3);

    public void shoot(ServerLevel var1, LivingEntity var2, InteractionHand var3, ItemStack var4);

    default public GunState getGunState(ItemStack stack) {
        return GunState.fromId(stack.m_41784_().m_128445_(WEAPON_STATE_KEY));
    }

    default public void setGunState(ItemStack stack, GunState state) {
        stack.m_41784_().m_128344_(WEAPON_STATE_KEY, state.getId());
    }

    default public long getReloadStartTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(RELOAD_TIMESTAMP_KEY);
    }

    default public void startReload(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        if (this.canReload(stack, shooter)) {
            this.setGunState(stack, GunState.RELOADING);
            stack.m_41784_().m_128356_(RELOAD_TIMESTAMP_KEY, level.m_46467_());
            this.onReloadStarted(stack, level, shooter);
        } else {
            this.playSFX((Level)level, shooter, SoundEvents.f_11797_);
        }
    }

    default public void finishReload(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        ItemStack ammoStack;
        this.setGunState(stack, GunState.NONE);
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (player.m_150110_().f_35937_) {
                this.setAmmo(stack, this.getMaxAmmo(stack));
                this.onReloadFinished(stack, level, shooter);
                return;
            }
        }
        if (!(ammoStack = this.findAmmoInInv(stack, shooter)).m_41619_() && ammoStack.m_41613_() >= this.getAmmoReloadCost()) {
            ammoStack.m_41774_(this.getAmmoReloadCost());
            this.setAmmo(stack, this.getMaxAmmo(stack));
            this.onReloadFinished(stack, level, shooter);
        } else {
            this.playSFX((Level)level, shooter, SoundEvents.f_11797_);
        }
    }

    default public void stopReload(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.setGunState(stack, GunState.NONE);
        this.onReloadStopped(stack, level, shooter);
    }

    default public void cancelReload(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.setGunState(stack, GunState.NONE);
        this.onReloadCanceled(stack, level, shooter);
    }

    default public void onReloadStarted(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_11843_);
    }

    default public void onReloadTick(ItemStack stack, ServerLevel level, LivingEntity shooter, long elapsedTime) {
    }

    default public void onReloadStopped(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_11841_);
    }

    default public void onReloadCanceled(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_11841_);
    }

    default public void onReloadFinished(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_11841_);
    }

    default public float getReloadProgress(long elapsedTime, long reloadTime) {
        return Mth.m_14036_((float)((float)elapsedTime / (float)reloadTime), (float)0.0f, (float)1.0f);
    }

    default public boolean canReload(ItemStack stack, LivingEntity shooter) {
        if (this.getAmmo(stack) >= this.getMaxAmmo(stack)) {
            return false;
        }
        ItemStack ammo = this.findAmmoInInv(stack, shooter);
        return !ammo.m_41619_() && ammo.m_41613_() >= this.getAmmoReloadCost();
    }

    default public float modifyProjectileInaccuracy(float baseInaccuracy, ItemStack stack) {
        return baseInaccuracy + (-1.0f * this.getAccuracy(stack) + 1.0f);
    }

    public float getAccuracy(ItemStack var1);

    public int getShootDelayTicks(ItemStack var1);

    default public float getFireRate(ItemStack stack) {
        return 20.0f / (float)this.getShootDelayTicks(stack);
    }

    public int getReloadDurationTicks(ItemStack var1);

    public float modifyProjectileDamage(float var1, ItemStack var2);

    public int modifyProjectileKnockBack(int var1, ItemStack var2);

    public int getMaxAmmo(ItemStack var1);

    public ItemStack findAmmoInInv(ItemStack var1, LivingEntity var2);

    default public int getAmmoReloadCost() {
        return 1;
    }

    default public boolean hasAmmo(ItemStack stack) {
        return this.getAmmo(stack) > 0;
    }

    default public int getAmmo(ItemStack stack) {
        return stack.m_41784_().m_128451_(AMMO_KEY);
    }

    default public void setAmmo(ItemStack stack, int amount) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(AMMO_KEY, Mth.m_14045_((int)amount, (int)0, (int)this.getMaxAmmo(stack)));
    }

    default public void addAmmo(ItemStack stack, int amount) {
        if (amount == 0) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(AMMO_KEY, Math.max(0, nbt.m_128451_(AMMO_KEY) + amount));
    }

    default public void consumeAmmo(ItemStack stack, int amount) {
        this.addAmmo(stack, -amount);
    }

    default public void consumeAmmo(LivingEntity shooter, ItemStack stack, int amount) {
        block3: {
            block2: {
                if (!(shooter instanceof Player)) break block2;
                Player player = (Player)shooter;
                if (player.m_150110_().f_35937_) break block3;
            }
            this.addAmmo(stack, -amount);
        }
    }

    default public void playSFX(Level level, LivingEntity shooter, SoundEvent soundEvent) {
        SoundSource soundSource = shooter instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
        level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), soundEvent, soundSource, 1.0f, 1.0f / (shooter.m_217043_().m_188501_() * 0.5f + 1.0f) + 0.2f);
    }

    public static enum GunState {
        NONE(0),
        SHOOTING(1),
        RELOADING(2);

        private final byte id;

        private GunState(byte id) {
            this.id = id;
        }

        public static GunState fromId(int id) {
            if (id == 0) {
                return NONE;
            }
            if (id == 1) {
                return SHOOTING;
            }
            if (id == 2) {
                return RELOADING;
            }
            return NONE;
        }

        public byte getId() {
            return this.id;
        }
    }
}

