/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon.gun;

import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.item.KeyPressListener;
import com.github.elenterius.biomancy.item.weapon.gun.Gun;
import com.github.elenterius.biomancy.item.weapon.gun.GunProperties;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.function.FloatOperator;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends ProjectileWeaponItem
implements Gun,
KeyPressListener {
    public static final Set<Enchantment> VALID_ENCHANTMENTS = Set.of(Enchantments.f_44989_, Enchantments.f_44988_, Enchantments.f_44960_);
    protected final GunProperties gunProperties;
    protected final ModProjectiles.ConfiguredProjectile<?> configuredProjectile;

    protected GunItem(Item.Properties properties, GunProperties gunProperties, ModProjectiles.ConfiguredProjectile<?> configuredProjectile) {
        super(properties);
        this.gunProperties = gunProperties;
        this.configuredProjectile = configuredProjectile;
    }

    protected static int getBonusReloadReduction(ItemStack stack) {
        return 5 * stack.getEnchantmentLevel(Enchantments.f_44960_);
    }

    protected static float getBonusProjectileDamageModifier(ItemStack stack) {
        return 0.6f * (float)stack.getEnchantmentLevel(Enchantments.f_44988_);
    }

    protected static int getBonusShootDelayReduction(ItemStack stack) {
        int level = 0;
        return 2 * level;
    }

    protected static int getBonusProjectileKnockBackModifier(ItemStack stack) {
        return stack.getEnchantmentLevel(Enchantments.f_44989_);
    }

    @Override
    public void shoot(ServerLevel level, LivingEntity shooter, InteractionHand usedHand, ItemStack projectileWeapon) {
        boolean success = this.configuredProjectile.shoot((Level)level, shooter, FloatOperator.IDENTITY, baseDamage -> this.modifyProjectileDamage(baseDamage, projectileWeapon), baseKnockBack -> this.modifyProjectileKnockBack(baseKnockBack, projectileWeapon), baseInaccuracy -> this.modifyProjectileInaccuracy(baseInaccuracy, projectileWeapon));
        if (success) {
            projectileWeapon.m_41622_(1, shooter, entity -> entity.m_21190_(usedHand));
            this.consumeAmmo(shooter, projectileWeapon, 1);
        }
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        Gun.GunState state = this.getGunState(stack);
        if (state == Gun.GunState.NONE && !this.canReload(stack, (LivingEntity)player)) {
            this.playSFX(level, (LivingEntity)player, SoundEvents.f_11797_);
            return InteractionResultHolder.m_19100_((Object)flags);
        }
        if (state == Gun.GunState.SHOOTING) {
            return InteractionResultHolder.m_19100_((Object)flags);
        }
        return InteractionResultHolder.m_19090_((Object)flags);
    }

    @Override
    public void onServerReceiveKeyPress(ItemStack stack, ServerLevel level, Player player, byte flags) {
        Gun.GunState state = this.getGunState(stack);
        if (state == Gun.GunState.NONE) {
            this.startReload(stack, level, (LivingEntity)player);
            return;
        }
        if (state == Gun.GunState.RELOADING) {
            this.cancelReload(stack, level, (LivingEntity)player);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (this.hasAmmo(stack)) {
            Gun.GunState state = this.getGunState(stack);
            if (state == Gun.GunState.RELOADING && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.cancelReload(stack, serverLevel, (LivingEntity)player);
            }
            this.setGunState(stack, Gun.GunState.SHOOTING);
            player.m_6672_(usedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_ammo"), true);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity shooter, ItemStack stack, int remainingUseDuration) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getGunState(stack) != Gun.GunState.SHOOTING) {
                return;
            }
            if (!this.hasAmmo(stack)) {
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_ammo"), true);
                }
                shooter.m_21253_();
                this.stopShooting(stack, serverLevel, shooter);
                return;
            }
            float elapsedTime = this.m_8105_(stack) - remainingUseDuration;
            int shootDelay = this.getShootDelayTicks(stack);
            if (elapsedTime == 0.0f && serverLevel.m_46467_() - this.getShootTimestamp(stack) < (long)shootDelay) {
                this.playSFX((Level)serverLevel, shooter, SoundEvents.f_11797_);
                return;
            }
            if (elapsedTime % (float)shootDelay == 0.0f) {
                this.shoot(serverLevel, shooter, shooter.m_7655_(), stack);
                stack.m_41784_().m_128356_("shoot_timestamp", serverLevel.m_46467_());
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        this.setGunState(stack, Gun.GunState.NONE);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.getGunState(stack) != Gun.GunState.RELOADING) {
                    return;
                }
                if (isSelected && this.canReload(stack, livingEntity)) {
                    long elapsedTime = serverLevel.m_46467_() - this.getReloadStartTime(stack);
                    if (elapsedTime < 0L) {
                        return;
                    }
                    this.onReloadTick(stack, serverLevel, livingEntity, elapsedTime);
                    if (elapsedTime >= (long)this.getReloadDurationTicks(stack)) {
                        this.finishReload(stack, serverLevel, livingEntity);
                    }
                    return;
                }
                this.stopReload(stack, serverLevel, livingEntity);
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return VALID_ENCHANTMENTS.contains(enchantment) || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public float getAccuracy(ItemStack stack) {
        return this.gunProperties.accuracy();
    }

    @Override
    public int getShootDelayTicks(ItemStack stack) {
        return this.gunProperties.shootDelayTicks() - GunItem.getBonusShootDelayReduction(stack);
    }

    @Override
    public int getReloadDurationTicks(ItemStack stack) {
        return this.gunProperties.reloadDurationTicks() - GunItem.getBonusReloadReduction(stack);
    }

    @Override
    public float modifyProjectileDamage(float baseDamage, ItemStack stack) {
        return baseDamage + this.gunProperties.projectileDamageModifier() + GunItem.getBonusProjectileDamageModifier(stack);
    }

    @Override
    public int modifyProjectileKnockBack(int baseKnockBack, ItemStack stack) {
        return baseKnockBack + GunItem.getBonusProjectileKnockBackModifier(stack);
    }

    @Override
    public int getMaxAmmo(ItemStack stack) {
        boolean level = false;
        return Mth.m_14143_((float)((float)this.gunProperties.maxAmmo() + (float)this.gunProperties.maxAmmo() * 0.5f * (float)level));
    }

    @Override
    public void stopShooting(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        if (this.gunProperties.isAutoReload()) {
            this.startReload(stack, level, shooter);
        }
    }

    @Override
    public ItemStack findAmmoInInv(ItemStack stack, LivingEntity shooter) {
        ItemStack ammo = shooter.m_6298_(stack);
        if (ammo.m_41720_() == Items.f_42412_) {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                if (player.m_150110_().f_35937_) {
                    ammo = ammo.m_41777_();
                    ammo.m_41764_(this.getAmmoReloadCost());
                    return ammo;
                }
            }
            if (this.m_6442_().test(ammo) || this.m_6437_().test(ammo)) {
                return ammo;
            }
            return ItemStack.f_41583_;
        }
        return ammo;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        this.appendGunStats(stack, tooltip);
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTranslationText("tooltip", "action_reload")).m_130948_(TextStyles.DARK_GRAY));
    }

    public void appendGunStats(ItemStack stack, List<Component> tooltip) {
        DecimalFormat df = ClientTextUtil.getDecimalFormatter("#.###");
        float fireRate = this.getFireRate(stack);
        float bonusFireRate = fireRate - 20.0f / (float)this.gunProperties.shootDelayTicks();
        tooltip.add((Component)TextComponentUtil.getTooltipText("fire_rate").m_130946_(String.format(": %s RPS ", df.format(fireRate))).m_7220_(this.formatBonusValue(df, bonusFireRate)).m_130940_(ChatFormatting.GRAY));
        float inaccuracy = this.modifyProjectileInaccuracy(this.configuredProjectile.inaccuracy(), stack);
        float bonusAccuracy = -1.0f * (inaccuracy - this.configuredProjectile.inaccuracy());
        tooltip.add((Component)TextComponentUtil.getTooltipText("accuracy").m_130946_(String.format(": %s ", df.format(inaccuracy))).m_7220_(this.formatBonusValue(df, bonusAccuracy, true)).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)TextComponentUtil.getTooltipText("ammo").m_130946_(String.format(": %d/%d ", this.getAmmo(stack), this.getMaxAmmo(stack))).m_130940_(ChatFormatting.GRAY));
        float reloadDurationSeconds = (float)this.getReloadDurationTicks(stack) / 20.0f;
        float bonusReloadReduction = -1.0f * (reloadDurationSeconds - (float)this.gunProperties.reloadDurationTicks() / 20.0f);
        tooltip.add((Component)TextComponentUtil.getTooltipText("reload_time").m_130946_(String.format(": %ss ", df.format(reloadDurationSeconds))).m_7220_(this.formatBonusValue(df, bonusReloadReduction, true)).m_130940_(ChatFormatting.GRAY));
        float damage = this.modifyProjectileDamage(this.configuredProjectile.damage(), stack);
        float bonusDamage = damage - this.configuredProjectile.damage();
        tooltip.add((Component)TextComponentUtil.getTooltipText("projectile_damage").m_130946_(String.format(": %s ", df.format(damage))).m_7220_(this.formatBonusValue(df, bonusDamage)).m_130940_(ChatFormatting.GRAY));
        int knockBack = this.modifyProjectileKnockBack(this.configuredProjectile.knockback(), stack);
        if (knockBack != 0) {
            int bonusValue = knockBack - this.configuredProjectile.knockback();
            tooltip.add((Component)TextComponentUtil.getTooltipText("projectile_knock_back").m_130946_(String.format(": %s ", df.format(knockBack))).m_7220_(this.formatBonusValue(df, bonusValue)).m_130940_(ChatFormatting.GRAY));
        }
    }

    private Component formatBonusValue(DecimalFormat df, float value) {
        return this.formatBonusValue(df, value, false);
    }

    private Component formatBonusValue(DecimalFormat df, float value, boolean inverted) {
        if (value == 0.0f) {
            return ComponentUtil.empty();
        }
        boolean isBeneficial = inverted ? value < 0.0f : value > 0.0f;
        Style style = isBeneficial ? TextStyles.LIME : TextStyles.ERROR;
        String formattedDecimal = (value > 0.0f ? "+" : "") + df.format(value);
        MutableComponent component = ComponentUtil.literal(formattedDecimal).m_130948_(style);
        return ComponentUtil.mutable().m_130946_("(").m_7220_((Component)component).m_130946_(")").m_130948_(TextStyles.DARK_GRAY);
    }
}

