/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.block.fleshkinchest.FleshkinChestBlockEntity;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.menu.ISlotZone;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class FleshkinChestMenu
extends PlayerContainerMenu {
    private final FleshkinChestBlockEntity chest;

    protected FleshkinChestMenu(int id, Inventory playerInventory, @Nullable FleshkinChestBlockEntity chest) {
        super((MenuType)ModMenuTypes.FLESHKIN_CHEST.get(), id, playerInventory, 150, 208);
        this.chest = chest;
        if (chest != null) {
            chest.startOpen(playerInventory.f_35978_);
            InventoryHandler<?> itemHandler = chest.getInventory();
            int posX = 26;
            int posY = 24;
            int rows = 6;
            int columns = 7;
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < columns; ++x) {
                    this.m_38897_((Slot)new SlotItemHandler(itemHandler, y * columns + x, posX + x * 18, posY + y * 18));
                }
            }
        }
    }

    public static FleshkinChestMenu createServerMenu(int screenId, Inventory playerInventory, FleshkinChestBlockEntity chest) {
        return new FleshkinChestMenu(screenId, playerInventory, chest);
    }

    public static FleshkinChestMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf extraData) {
        FleshkinChestBlockEntity be;
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        FleshkinChestBlockEntity chest = blockEntity instanceof FleshkinChestBlockEntity ? (be = (FleshkinChestBlockEntity)blockEntity) : null;
        return new FleshkinChestMenu(screenId, playerInventory, chest);
    }

    public boolean m_6875_(Player player) {
        return this.chest != null && this.chest.canPlayerInteract(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        switch (SlotZone.getZoneFromIndex(index)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INVENTORY: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_HOTBAR, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, true);
                break;
            }
            case PLAYER_HOTBAR: {
                boolean bl = this.mergeIntoEither(SlotZone.INVENTORY, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
                break;
            }
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoEither(SlotZone.INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"GlandMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    public InventoryHandler getInventory() {
        return this.chest.getInventory();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.chest != null) {
            this.chest.stopOpen(player);
        }
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(SlotZone.PLAYER_HOTBAR.lastIndexPlus1, 27),
        INVENTORY(SlotZone.PLAYER_MAIN_INVENTORY.lastIndexPlus1, 42);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

