/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.menu.ISlotZone;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerContainerMenu
extends AbstractContainerMenu {
    protected PlayerContainerMenu(@Nullable MenuType<?> type, int containerId, Inventory playerInventory) {
        this(type, containerId, playerInventory, 84, 142);
    }

    protected PlayerContainerMenu(@Nullable MenuType<?> type, int containerId, Inventory playerInventory, int invPosY, int hotbarPosY) {
        super(type, containerId);
        this.initPlayerInvSlots(playerInventory, invPosY, hotbarPosY);
    }

    protected PlayerContainerMenu(@Nullable MenuType<?> type, int containerId, Inventory playerInventory, int pX, int invPosY, int hotbarPosY) {
        super(type, containerId);
        this.initPlayerInvSlots(playerInventory, pX, invPosY, hotbarPosY);
    }

    protected void initPlayerInvSlots(Inventory playerInventory, int invPosY, int hotbarPosY) {
        this.initPlayerInvSlots(playerInventory, 8, invPosY, hotbarPosY);
    }

    protected void initPlayerInvSlots(Inventory playerInventory, int pX, int invPosY, int hotbarPosY) {
        int SLOTS_PER_ROW = 9;
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        for (int idx = 0; idx < 9; ++idx) {
            this.m_38897_(new PlayerInvSlot(playerInventory, idx, pX + 18 * idx, hotbarPosY));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int posX = pX + x * 18;
                int posY = invPosY + y * 18;
                this.m_38897_(new PlayerInvSlot(playerInventory, slotNumber, posX, posY));
            }
        }
    }

    protected void onPlayerMainInventoryChanged(Inventory inventory) {
    }

    protected boolean mergeInto(ISlotZone zone, ItemStack stack, boolean fillFromEnd) {
        return this.m_38903_(stack, zone.getFirstIndex(), zone.getLastIndexPlusOne(), fillFromEnd);
    }

    protected boolean mergeIntoEither(ISlotZone zoneA, ISlotZone zoneB, ItemStack stack, boolean fillFromEnd) {
        return this.mergeInto(zoneA, stack, fillFromEnd) || this.mergeInto(zoneB, stack, fillFromEnd);
    }

    private class PlayerInvSlot
    extends Slot {
        public PlayerInvSlot(Inventory playerInventory, int index, int x, int y) {
            super((Container)playerInventory, index, x, y);
        }

        public void m_6654_() {
            super.m_6654_();
            PlayerContainerMenu.this.onPlayerMainInventoryChanged((Inventory)this.f_40218_);
        }
    }
}

