/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.block.storagesac.StorageSacBlockEntity;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.menu.ISlotZone;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class StorageSacMenu
extends PlayerContainerMenu {
    private final StorageSacBlockEntity storageSac;

    protected StorageSacMenu(int id, Inventory playerInventory, @Nullable StorageSacBlockEntity storageSac) {
        super((MenuType)ModMenuTypes.STORAGE_SAC.get(), id, playerInventory, 88, 146);
        this.storageSac = storageSac;
        if (storageSac != null) {
            InventoryHandler<?> itemHandler = storageSac.getInventory();
            int posX = 44;
            int posY = 17;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 5; ++x) {
                    this.m_38897_((Slot)new SlotItemHandler(itemHandler, x + 5 * y, posX + x * 18, posY + y * 18));
                }
            }
        }
    }

    public static StorageSacMenu createServerMenu(int screenId, Inventory playerInventory, StorageSacBlockEntity storageSac) {
        return new StorageSacMenu(screenId, playerInventory, storageSac);
    }

    public static StorageSacMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf extraData) {
        StorageSacBlockEntity be;
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        StorageSacBlockEntity storageSac = blockEntity instanceof StorageSacBlockEntity ? (be = (StorageSacBlockEntity)blockEntity) : null;
        return new StorageSacMenu(screenId, playerInventory, storageSac);
    }

    public boolean m_6875_(Player player) {
        return this.storageSac != null && this.storageSac.canPlayerInteract(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        switch (SlotZone.getZoneFromIndex(index)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INVENTORY: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_HOTBAR, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, true);
                break;
            }
            case PLAYER_HOTBAR: {
                boolean bl = this.mergeIntoEither(SlotZone.INVENTORY, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
                break;
            }
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoEither(SlotZone.INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"GlandMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(PLAYER_HOTBAR, 27),
        INVENTORY(PLAYER_MAIN_INVENTORY, 15);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(SlotZone preSlotZone, int numberOfSlots) {
            this(preSlotZone.lastIndexPlus1, numberOfSlots);
        }

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

