/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.mixin;

import com.github.elenterius.biomancy.entity.mob.ChromaSheep;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Animal.class})
public abstract class AnimalMixin {
    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"canMate"})
    private void onCanMate(Animal otherAnimal, CallbackInfoReturnable<Boolean> cir) {
        Animal thisAnimal = (Animal)this;
        if (thisAnimal == otherAnimal) {
            return;
        }
        if (AnimalMixin.biomancy$canSheepMate(thisAnimal, otherAnimal) && thisAnimal.m_27593_() && otherAnimal.m_27593_()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private static boolean biomancy$canSheepMate(Animal thisAnimal, Animal otherAnimal) {
        return thisAnimal.getClass() == Sheep.class && otherAnimal instanceof ChromaSheep;
    }
}

