/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.mixin;

import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.init.tags.ModItemTags;
import com.github.elenterius.biomancy.item.ShieldBlockingListener;
import com.github.elenterius.biomancy.statuseffect.StatusEffectHandler;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.Collection;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected ItemStack f_20935_;
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;

    private LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    public abstract AttributeMap m_21204_();

    @Shadow
    public abstract Collection<MobEffectInstance> m_21220_();

    @Inject(method={"getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onGetAttributeValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        if (attribute == Attributes.f_22281_ && !this.m_21204_().m_22171_(Attributes.f_22281_) && this.m_21023_((MobEffect)ModMobEffects.FRENZY.get())) {
            cir.setReturnValue((Object)1.0);
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21023_((MobEffect)ModMobEffects.CORROSIVE.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"blockUsingShield"}, at={@At(value="HEAD")})
    private void onBlockUsingShield(LivingEntity attacker, CallbackInfo ci) {
        Item item = this.f_20935_.m_41720_();
        if (item instanceof ShieldBlockingListener) {
            ShieldBlockingListener listener = (ShieldBlockingListener)item;
            listener.onShieldBlocking(this.f_20935_, (LivingEntity)this, attacker);
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddEffect(MobEffectInstance effectInstance, @Nullable Entity source, CallbackInfoReturnable<Boolean> cir) {
        if ((source instanceof AreaEffectCloud || source instanceof ThrownPotion || source instanceof Arrow) && !StatusEffectHandler.canApplySplashEffectIfAllowed(effectInstance.m_19544_(), this.biomancy$self())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addEatEffect"}, at={@At(value="TAIL")})
    private void onAddEatEffect(ItemStack food, Level level, LivingEntity livingEntity, CallbackInfo ci) {
        if (!level.f_46443_ && LivingEntityMixin.biomancy$getRawMeatNutrition(food) > 2 && livingEntity.m_217043_().m_188501_() < 0.2f) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.PRIMORDIAL_INFESTATION.get(), 160, 0));
        }
    }

    @ModifyArg(method={"curePotionEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"), remap=false)
    private MobEffectInstance onCurePotionEffects(MobEffectInstance effectInstance, @Share(value="removedFrenzy") LocalRef<MobEffectInstance> removedFrenzyRef) {
        if (effectInstance.m_19544_() == ModMobEffects.FRENZY.get()) {
            removedFrenzyRef.set((Object)effectInstance);
        }
        return effectInstance;
    }

    @Inject(method={"curePotionEffects"}, at={@At(value="TAIL")}, remap=false)
    private void onPostCurePotionEffects(ItemStack curativeItem, CallbackInfoReturnable<Boolean> cir, @Share(value="removedFrenzy") LocalRef<MobEffectInstance> removedFrenzyRef) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        MobEffectInstance removedFrenzyEffect = (MobEffectInstance)removedFrenzyRef.get();
        if (removedFrenzyEffect == null) {
            return;
        }
        StatusEffectHandler.addWithdrawalAfterFrenzy(this.biomancy$self(), removedFrenzyEffect);
    }

    @ModifyArg(method={"tickEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"))
    private MobEffectInstance onTickEffects(MobEffectInstance effectInstance, @Share(value="expiredFrenzy") LocalRef<MobEffectInstance> expiredFrenzyRef) {
        if (effectInstance.m_19544_() == ModMobEffects.FRENZY.get()) {
            expiredFrenzyRef.set((Object)effectInstance);
        }
        return effectInstance;
    }

    @Inject(method={"tickEffects"}, at={@At(value="TAIL")})
    private void onPostTickEffects(CallbackInfo ci, @Share(value="expiredFrenzy") LocalRef<MobEffectInstance> expiredFrenzyRef) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        MobEffectInstance removedFrenzyEffect = (MobEffectInstance)expiredFrenzyRef.get();
        if (removedFrenzyEffect == null) {
            return;
        }
        StatusEffectHandler.addWithdrawalAfterFrenzy(this.biomancy$self(), removedFrenzyEffect);
    }

    @Unique
    private static int biomancy$getRawMeatNutrition(ItemStack itemStack) {
        if (!itemStack.m_41614_()) {
            return 0;
        }
        FoodProperties food = itemStack.getFoodProperties(null);
        return food != null && food.m_38746_() && itemStack.m_204117_(ModItemTags.RAW_MEATS) ? food.m_38744_() : 0;
    }

    @Unique
    private LivingEntity biomancy$self() {
        return (LivingEntity)this;
    }
}

