/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.network;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.BioForgingRecipe;
import com.github.elenterius.biomancy.network.BioForgeRecipeMessage;
import com.github.elenterius.biomancy.network.BioLabFilterMessage;
import com.github.elenterius.biomancy.network.KeyPressMessage;
import com.github.elenterius.biomancy.util.ItemStackFilterList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class ModNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel SIMPLE_NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)BiomancyMod.createRL("main"), () -> "1", "1"::equals, "1"::equals);

    private ModNetworkHandler() {
    }

    public static void sendKeyBindPressToServer(InteractionHand hand, byte flag) {
        EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        ModNetworkHandler.sendKeyBindPressToServer(slot, flag);
    }

    public static void sendKeyBindPressToServer(EquipmentSlot slot, byte flag) {
        SIMPLE_NETWORK_CHANNEL.sendToServer((Object)new KeyPressMessage(slot.m_20750_(), flag));
    }

    public static void sendKeyBindPressToServer(int slotIndex, byte flag) {
        SIMPLE_NETWORK_CHANNEL.sendToServer((Object)new KeyPressMessage(slotIndex, flag));
    }

    public static void sendBioForgeRecipeToServer(int containerId, BioForgingRecipe recipe) {
        SIMPLE_NETWORK_CHANNEL.sendToServer((Object)new BioForgeRecipeMessage(containerId, recipe.m_6423_()));
    }

    public static void sendBioLabFilterToClient(ServerPlayer player, int containerId, ItemStackFilterList filters) {
        SIMPLE_NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BioLabFilterMessage(containerId, filters));
    }

    public static void register() {
        int id = -1;
        SIMPLE_NETWORK_CHANNEL.registerMessage(++id, KeyPressMessage.class, KeyPressMessage::encode, KeyPressMessage::decode, KeyPressMessage::handle);
        SIMPLE_NETWORK_CHANNEL.registerMessage(++id, BioForgeRecipeMessage.class, BioForgeRecipeMessage::encode, BioForgeRecipeMessage::decode, BioForgeRecipeMessage::handle);
        SIMPLE_NETWORK_CHANNEL.registerMessage(++id, BioLabFilterMessage.class, BioLabFilterMessage::encode, BioLabFilterMessage::decode, BioLabFilterMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }
}

