/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.mixin.accessor.TadpoleAccessor;
import com.github.elenterius.biomancy.serum.BasicSerum;
import com.github.elenterius.biomancy.util.MobUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AgeingSerum
extends BasicSerum {
    public AgeingSerum(int color) {
        super(color);
    }

    @Override
    public boolean canAffectEntity(CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        return target instanceof Mob && target.m_6162_() || target instanceof Guardian || target instanceof Tadpole;
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        if (target instanceof Guardian) {
            Guardian guardian = (Guardian)target;
            this.convertToElderGuardian(level, guardian);
        } else if (target instanceof Tadpole) {
            Tadpole tadpole = (Tadpole)target;
            this.convertToFrog(level, tadpole);
        } else if (target instanceof Mob) {
            Mob mob = (Mob)target;
            MobUtil.convertToAdult(mob);
        }
    }

    private void convertToFrog(ServerLevel level, Tadpole tadpole) {
        ((TadpoleAccessor)tadpole).biomancy$AgeUp();
        if (!tadpole.m_20067_()) {
            level.m_5898_(null, 1026, tadpole.m_20183_(), 0);
        }
    }

    private void convertToElderGuardian(ServerLevel level, Guardian guardian) {
        MobUtil.convertMobTo(level, guardian, EntityType.f_20563_, true, (oldGuardian, elderGuardian) -> {
            if (!oldGuardian.m_20067_()) {
                level.m_5898_(null, 1026, oldGuardian.m_20183_(), 0);
            }
        });
    }

    @Override
    public boolean canAffectPlayerSelf(CompoundTag tag, Player targetSelf) {
        return false;
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
    }
}

