/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.serum.BasicSerum;
import com.github.elenterius.biomancy.util.MobUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.player.Player;

public class RejuvenationSerum
extends BasicSerum {
    public RejuvenationSerum(int color) {
        super(color);
    }

    @Override
    public boolean canAffectEntity(CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        return target instanceof Mob && !target.m_6162_() || target instanceof ElderGuardian || target instanceof Frog;
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        if (target instanceof ElderGuardian) {
            ElderGuardian elderGuardian = (ElderGuardian)target;
            this.convertToGuardian(level, elderGuardian);
        } else if (target instanceof Frog) {
            Frog frog = (Frog)target;
            this.convertToTadpole(level, frog);
        } else if (target instanceof Mob) {
            Mob mob = (Mob)target;
            MobUtil.convertToBaby(mob, true);
        }
    }

    private void convertToTadpole(ServerLevel level, Frog frog) {
        MobUtil.convertMobTo(level, frog, EntityType.f_217013_, true, (oldFrog, tadpole) -> {
            if (!oldFrog.m_20067_()) {
                level.m_5898_(null, 1026, oldFrog.m_20183_(), 0);
            }
        });
    }

    private void convertToGuardian(ServerLevel level, ElderGuardian elderGuardian) {
        MobUtil.convertMobTo(level, elderGuardian, EntityType.f_20455_, true, (oldElderGuardian, guardian) -> {
            if (!oldElderGuardian.m_20067_()) {
                level.m_5898_(null, 1026, oldElderGuardian.m_20183_(), 0);
            }
        });
    }

    @Override
    public boolean canAffectPlayerSelf(CompoundTag tag, Player targetSelf) {
        return false;
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
    }
}

