/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.statuseffect;

import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.mixin.accessor.MobEffectInstanceAccessor;
import com.github.elenterius.biomancy.statuseffect.StackingStatusEffect;
import com.github.elenterius.biomancy.statuseffect.StatusEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BleedEffect
extends StatusEffect
implements StackingStatusEffect {
    private int maxEffectStack;

    public BleedEffect(MobEffectCategory category, int color, int maxEffectStack) {
        super(category, color, false);
        this.maxEffectStack = maxEffectStack;
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return (duration + 1) % 40 == 0;
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.m_21023_(MobEffects.f_19605_) || livingEntity.m_21023_(MobEffects.f_19601_)) {
            livingEntity.m_21195_((MobEffect)this);
            return;
        }
        if (livingEntity.m_20142_()) {
            this.increaseEffectDurationBy(livingEntity, 200);
        } else if (livingEntity.m_6047_()) {
            this.reduceEffectDurationBy(livingEntity, 200);
        }
        int effectLevel = amplifier + 1;
        livingEntity.m_6469_(ModDamageSources.bleed(livingEntity.m_9236_(), null), (float)effectLevel);
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float xz = livingEntity.m_20205_() * 0.25f;
            float y = livingEntity.m_20206_() * 0.25f;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FALLING_BLOOD.get()), livingEntity.m_20185_(), livingEntity.m_20227_(0.5), livingEntity.m_20189_(), 4, (double)xz, (double)y, (double)xz, 0.0);
        }
    }

    private void reduceEffectDurationBy(LivingEntity livingEntity, int ticks) {
        MobEffectInstance effectInstance = livingEntity.m_21124_((MobEffect)this);
        if (effectInstance == null) {
            return;
        }
        int reducedDuration = effectInstance.m_19557_() - ticks;
        if (reducedDuration > 0) {
            ((MobEffectInstanceAccessor)effectInstance).biomancy$setDuration(reducedDuration);
            ((MobEffectInstanceAccessor)effectInstance).biomancy$getFactorData().ifPresent(factorData -> factorData.m_267690_(effectInstance));
        } else {
            livingEntity.m_21195_((MobEffect)this);
        }
    }

    private void increaseEffectDurationBy(LivingEntity livingEntity, int ticks) {
        MobEffectInstance effectInstance = livingEntity.m_21124_((MobEffect)this);
        if (effectInstance == null) {
            return;
        }
        int increasedDuration = effectInstance.m_19557_() + ticks;
        ((MobEffectInstanceAccessor)effectInstance).biomancy$setDuration(increasedDuration);
        ((MobEffectInstanceAccessor)effectInstance).biomancy$getFactorData().ifPresent(factorData -> factorData.m_267690_(effectInstance));
    }

    @Override
    public int getMaxEffectStack() {
        return this.maxEffectStack;
    }
}

