/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.statuseffect;

import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.tags.ModDamageTypeTags;
import com.github.elenterius.biomancy.statuseffect.StatusEffect;
import com.github.elenterius.biomancy.util.CombatUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class CorrosiveEffect
extends StatusEffect {
    public CorrosiveEffect(MobEffectCategory category, int color) {
        super(category, color, false);
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        Level level;
        int effectLevel = amplifier + 1;
        boolean isWet = livingEntity.m_20071_();
        float conversionProbability = 0.1f + 0.05f * (float)effectLevel + (isWet ? 0.15f : 0.0f);
        Level level2 = livingEntity.m_9236_();
        if (level2 instanceof ServerLevel) {
            DamageSource lastDamageSource;
            ServerLevel serverLevel = (ServerLevel)level2;
            if (livingEntity.m_9236_().f_46441_.m_188501_() < conversionProbability && (lastDamageSource = livingEntity.m_21225_()) != null && lastDamageSource.m_269533_(ModDamageTypeTags.FORGE_IS_ACID)) {
                this.convertZombieToSkeleton(serverLevel, livingEntity);
            }
        }
        if (!livingEntity.m_6084_()) {
            return;
        }
        float damage = (float)(2 * effectLevel) + (isWet ? 0.5f : 0.0f);
        CombatUtil.hurtWithAcid(livingEntity, damage);
        if (livingEntity.m_9236_().f_46441_.m_188501_() < 0.85f && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float xz = livingEntity.m_20205_() * 0.25f;
            float y = livingEntity.m_20206_() * 0.25f;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FALLING_ACID.get()), livingEntity.m_20185_(), livingEntity.m_20227_(0.5), livingEntity.m_20189_(), 4, (double)xz, (double)y, (double)xz, 0.0);
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return (duration + 1) % 8 == 0;
    }

    private boolean convertZombieToSkeleton(ServerLevel level, LivingEntity livingEntity) {
        SkeletonHorse horse;
        ZombieHorse zombieHorse;
        Zombie zombie;
        if (livingEntity instanceof Zombie && ForgeEventFactory.canLivingConvert((LivingEntity)(zombie = (Zombie)livingEntity), (EntityType)EntityType.f_20524_, timer -> {})) {
            Skeleton skeleton = (Skeleton)zombie.m_21406_(EntityType.f_20524_, true);
            if (skeleton != null) {
                skeleton.f_19802_ = 60;
                ForgeEventFactory.onLivingConvert((LivingEntity)zombie, (LivingEntity)skeleton);
                if (!zombie.m_20067_()) {
                    level.m_5898_(null, 1026, zombie.m_20183_(), 0);
                }
                return true;
            }
        } else if (livingEntity instanceof ZombieHorse && ForgeEventFactory.canLivingConvert((LivingEntity)(zombieHorse = (ZombieHorse)livingEntity), (EntityType)EntityType.f_20525_, timer -> {}) && (horse = (SkeletonHorse)zombieHorse.m_21406_(EntityType.f_20525_, true)) != null) {
            horse.f_19802_ = 60;
            UUID owner = zombieHorse.m_21805_();
            if (owner != null) {
                horse.m_30586_(owner);
            }
            horse.m_30651_(zombieHorse.m_30614_());
            ForgeEventFactory.onLivingConvert((LivingEntity)zombieHorse, (LivingEntity)horse);
            if (!zombieHorse.m_20067_()) {
                level.m_5898_(null, 1026, zombieHorse.m_20183_(), 0);
            }
            return true;
        }
        return false;
    }
}

