/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import java.util.List;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public final class CombatUtil {
    private CombatUtil() {
    }

    public static boolean canPierceThroughArmor(ItemStack weapon, LivingEntity target, @Nullable LivingEntity attacker) {
        float pierceProbability = 0.0f;
        for (ItemStack itemStack : target.m_6168_()) {
            if (!(itemStack.m_41720_() instanceof AcolyteArmorItem)) continue;
            pierceProbability += 0.25f;
        }
        int pierceLevel = weapon.getEnchantmentLevel(Enchantments.f_44961_);
        float pct = CombatRules.m_19272_((float)20.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))) / 20.0f;
        return target.m_217043_().m_188501_() < pct + 0.075f * (float)pierceLevel + pierceProbability;
    }

    public static void performWaterAOE(Level level, Entity attacker, double maxDistance) {
        AABB aabb = attacker.m_20191_().m_82377_(maxDistance, maxDistance / 2.0, maxDistance);
        List entities = level.m_6443_(LivingEntity.class, aabb, LivingEntity::m_6126_);
        if (!entities.isEmpty()) {
            double maxDistSq = maxDistance * maxDistance;
            for (LivingEntity victim : entities) {
                if (!(attacker.m_20280_((Entity)victim) < maxDistSq)) continue;
                victim.m_6469_(level.m_269111_().m_269104_((Entity)victim, attacker), 1.0f);
            }
        }
    }

    public static boolean hasAcidEffect(LivingEntity livingEntity) {
        return livingEntity.m_21023_((MobEffect)ModMobEffects.CORROSIVE.get());
    }

    public static void applyAcidEffect(LivingEntity livingEntity, int seconds) {
        if (livingEntity.m_21023_((MobEffect)ModMobEffects.CORROSIVE.get())) {
            return;
        }
        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.CORROSIVE.get(), seconds * 20, 0));
        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ARMOR_SHRED.get(), (seconds + 3) * 20, 0));
    }

    public static void hurtWithAcid(LivingEntity livingEntity, float damage) {
        livingEntity.m_6469_(ModDamageSources.acid(livingEntity.m_9236_(), null), damage);
        livingEntity.f_19802_ = 0;
    }

    public static void hurtWithBleed(LivingEntity livingEntity, float damage) {
        livingEntity.m_6469_(ModDamageSources.bleed(livingEntity.m_9236_(), null), damage);
        livingEntity.f_19802_ = 0;
    }

    public static void applyBleedEffect(LivingEntity livingEntity, int seconds) {
        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.BLEED.get(), seconds * 20, 0, false, false, true));
    }

    public static int getBleedEffectLevel(LivingEntity target) {
        MobEffectInstance effectInstance = target.m_21124_((MobEffect)ModMobEffects.BLEED.get());
        if (effectInstance == null) {
            return 0;
        }
        return effectInstance.m_19564_() + 1;
    }
}

