/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.util.ItemStackFilter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class ItemStackFilterList
extends AbstractList<ItemStackFilter>
implements INBTSerializable<ListTag> {
    private final List<ItemStackFilter> filters;

    protected ItemStackFilterList(List<ItemStackFilter> filters) {
        this.filters = new ArrayList<ItemStackFilter>(filters);
    }

    public static ItemStackFilterList of(ItemStackFilter filter) {
        return new ItemStackFilterList(List.of(filter));
    }

    public static ItemStackFilterList of(ItemStackFilter filter, int size) {
        return new ItemStackFilterList(IntStream.range(0, size).mapToObj(x -> filter).toList());
    }

    public static ItemStackFilterList of(List<ItemStackFilter> filters) {
        return new ItemStackFilterList(filters);
    }

    public void setAllFilters(ItemStackFilter filter) {
        this.filters.replaceAll(ignored -> filter);
    }

    public void setFilter(int index, ItemStackFilter filter) {
        this.filters.set(index, filter);
    }

    @Override
    public ItemStackFilter set(int index, ItemStackFilter filter) {
        return this.filters.set(index, filter);
    }

    @Override
    public ItemStackFilter get(int index) {
        return this.filters.get(index);
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    public boolean test(int index, ItemStack stack) {
        if (index <= 0 || index > this.size()) {
            return false;
        }
        return this.filters.get(index).test(stack);
    }

    public void deserializeNBT(ListTag listTag) {
        this.filters.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            this.filters.add(ItemStackFilter.of(listTag.m_128728_(i)));
        }
    }

    public ListTag serializeNBT() {
        ListTag listTag = new ListTag();
        for (ItemStackFilter filter : this.filters) {
            listTag.add((Object)filter.serializeNBT());
        }
        return listTag;
    }
}

