/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.init.ModCapabilities;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class LevelUtil {
    private LevelUtil() {
    }

    public static LazyOptional<IItemHandler> getItemHandler(ServerLevel level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null) {
            return blockEntity.getCapability(ModCapabilities.ITEM_HANDLER, direction);
        }
        return LazyOptional.empty();
    }

    public static int getMaxBrightness(Level level, BlockPos pos) {
        return level.m_5518_().m_75831_(pos, 0);
    }

    public static int getNumOfBlocksAbove(BlockGetter level, BlockPos pos, Block targetBlock, int maxHeight) {
        int i;
        for (i = 0; i < maxHeight && level.m_8055_(pos.m_6630_(i + 1)).m_60734_() == targetBlock; ++i) {
        }
        return i;
    }

    public static int getNumOfBlocksBelow(BlockGetter level, BlockPos pos, Block targetBlock, int maxHeight) {
        int i;
        for (i = 0; i < maxHeight && level.m_8055_(pos.m_6625_(i + 1)).m_60734_() == targetBlock; ++i) {
        }
        return i;
    }

    public static boolean isBlockNearby(ServerLevel level, BlockPos pos, int range, Predicate<BlockState> predicate) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int y = 0;
        while (y <= range) {
            for (int xz = 0; xz < range; ++xz) {
                int x = 0;
                while (x <= xz) {
                    int z;
                    int n = z = x < xz && x > -xz ? xz : 0;
                    while (z <= xz) {
                        if (x * x + y * y + z * z <= range * range) {
                            mutablePos.m_122154_((Vec3i)pos, x, y - 1, z);
                            if (predicate.test(level.m_8055_((BlockPos)mutablePos))) {
                                return true;
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return false;
    }

    public static boolean isChunkCloserToPosThan(int chunkX, int chunkZ, BlockPos pos, double distanceSquared) {
        double dz;
        int minBlockX = SectionPos.m_123223_((int)chunkX);
        int minBlockZ = SectionPos.m_123223_((int)chunkZ);
        int maxBlockX = SectionPos.m_175554_((int)chunkX, (int)15);
        int maxBlockZ = SectionPos.m_175554_((int)chunkZ, (int)15);
        double closestX = Mth.m_14045_((int)pos.m_123341_(), (int)minBlockX, (int)maxBlockX);
        double closestZ = Mth.m_14045_((int)pos.m_123343_(), (int)minBlockZ, (int)maxBlockZ);
        double dx = (double)pos.m_123341_() - closestX;
        return dx * dx + (dz = (double)pos.m_123343_() - closestZ) * dz < distanceSquared;
    }

    @Nullable
    public static <T extends BlockEntity> T findNearestBlockEntity(ServerLevel level, BlockPos pos, int searchDist, Class<T> clazz) {
        if (searchDist <= 0) {
            return null;
        }
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        int searchDistSqr = searchDist * searchDist;
        int chunkSearchDist = Mth.m_14167_((float)((float)searchDist / 16.0f));
        BlockEntity nearestBlockEntity = null;
        double nearestDistSqr = (double)searchDistSqr + 0.1;
        for (int chunkDist = 0; chunkDist <= chunkSearchDist; ++chunkDist) {
            int x = 0;
            while (x <= chunkDist) {
                int z;
                int n = z = x < chunkDist && x > -chunkDist ? chunkDist : 0;
                while (z <= chunkDist) {
                    if (level.m_7232_(chunkX + x, chunkZ + z) && LevelUtil.isChunkCloserToPosThan(chunkX + x, chunkZ + z, pos, nearestDistSqr)) {
                        LevelChunk chunk = level.m_6325_(chunkX + x, chunkZ + z);
                        for (BlockEntity blockEntity : chunk.m_62954_().values()) {
                            double distSqr;
                            if (blockEntity.m_58901_() || !clazz.isInstance(blockEntity) || !((distSqr = blockEntity.m_58899_().m_123331_((Vec3i)pos)) <= (double)searchDistSqr) || !(distSqr < nearestDistSqr)) continue;
                            nearestBlockEntity = (BlockEntity)clazz.cast(blockEntity);
                            nearestDistSqr = distSqr;
                        }
                    }
                    z = z > 0 ? -z : 1 - z;
                }
                x = x > 0 ? -x : 1 - x;
            }
        }
        return (T)nearestBlockEntity;
    }
}

