/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.frog.Tadpole;

public enum MobMaturity {
    ANY(entity -> true),
    BABY(entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6162_() || entity instanceof Tadpole;
    }),
    ADULT(entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6162_();
    });

    private final Predicate<Entity> predicate;

    private MobMaturity(Predicate<Entity> predicate) {
        this.predicate = predicate;
    }

    public static MobMaturity fromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= MobMaturity.values().length) {
            return ANY;
        }
        return MobMaturity.values()[ordinal];
    }

    public boolean test(Entity entity) {
        return this.predicate.test(entity);
    }
}

