/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.block.property.BlockPropertyUtil;
import com.github.elenterius.biomancy.util.LevelUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public final class PillarPlantUtil {
    public static final Set<Block> PILLAR_PLANTS = Set.of(Blocks.f_50130_, Blocks.f_50128_);
    public static final PillarPlantHelper CACTUS_HELPER = new PillarPlantHelper(Blocks.f_50128_, 3, CactusBlock.f_51131_, true);
    public static final PillarPlantHelper SUGAR_CANE_HELPER = new PillarPlantHelper(Blocks.f_50130_, 3, SugarCaneBlock.f_57164_);

    private PillarPlantUtil() {
    }

    public static boolean isPillarPlant(Block block) {
        return PILLAR_PLANTS.contains(block);
    }

    public static boolean applyGrowthBoost(Level level, BlockPos pos, BlockState state, Block block) {
        if (block == SUGAR_CANE_HELPER.block()) {
            return PillarPlantUtil.handleGrowth(SUGAR_CANE_HELPER, level, pos, state, PillarPlantUtil.SUGAR_CANE_HELPER.defaultHeight, PillarPlantUtil.SUGAR_CANE_HELPER.maxAge);
        }
        if (block == CACTUS_HELPER.block()) {
            return PillarPlantUtil.handleGrowth(CACTUS_HELPER, level, pos, state, PillarPlantUtil.CACTUS_HELPER.defaultHeight, PillarPlantUtil.CACTUS_HELPER.maxAge);
        }
        return false;
    }

    public static boolean applyMegaGrowthBoost(Level level, BlockPos pos, BlockState state, Block block) {
        if (block == SUGAR_CANE_HELPER.block()) {
            return PillarPlantUtil.handleMegaGrowth(SUGAR_CANE_HELPER, level, pos, state, PillarPlantUtil.SUGAR_CANE_HELPER.defaultHeight * 3, PillarPlantUtil.SUGAR_CANE_HELPER.maxAge);
        }
        if (block == CACTUS_HELPER.block()) {
            return PillarPlantUtil.handleMegaGrowth(CACTUS_HELPER, level, pos, state, PillarPlantUtil.CACTUS_HELPER.defaultHeight * 3, PillarPlantUtil.CACTUS_HELPER.maxAge);
        }
        return false;
    }

    public static boolean handleGrowth(PillarPlantHelper plantHelper, Level level, BlockPos pos, BlockState state) {
        return PillarPlantUtil.handleGrowth(plantHelper, level, pos, state, plantHelper.defaultHeight, level.f_46441_.m_188503_(3) + 2);
    }

    private static boolean handleGrowth(PillarPlantHelper plantHelper, Level level, BlockPos pos, BlockState state, int maxHeight, int ageModifier) {
        if (plantHelper.canGrow((BlockGetter)level, pos, state, maxHeight)) {
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                plantHelper.grow(serverLevel, pos, state, maxHeight, ageModifier);
                serverLevel.m_46796_(2005, pos, 5);
            }
            return true;
        }
        return false;
    }

    private static boolean handleMegaGrowth(PillarPlantHelper plantHelper, Level level, BlockPos pos, BlockState state, int maxHeight, int ageModifier) {
        boolean hasGrown = false;
        for (int i = 0; i < 3 && !state.m_60795_() && plantHelper.canGrow((BlockGetter)level, pos, state, maxHeight); ++i) {
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                plantHelper.grow(serverLevel, pos, state, maxHeight, ageModifier);
                serverLevel.m_46796_(2005, pos, 5);
            }
            pos = pos.m_7494_();
            state = level.m_8055_(pos);
            hasGrown = true;
        }
        return hasGrown;
    }

    public record PillarPlantHelper(Block block, int defaultHeight, IntegerProperty ageProperty, int maxAge, boolean callNeighborChanged) {
        public PillarPlantHelper(Block block, int defaultHeight, IntegerProperty ageProperty) {
            this(block, defaultHeight, ageProperty, BlockPropertyUtil.getMaxValue(ageProperty), false);
        }

        public PillarPlantHelper(Block block, int defaultHeight, IntegerProperty ageProperty, boolean callNeighborChanged) {
            this(block, defaultHeight, ageProperty, BlockPropertyUtil.getMaxValue(ageProperty), callNeighborChanged);
        }

        public boolean isNotFullyGrown(BlockState state) {
            return (Integer)state.m_61143_((Property)this.ageProperty) < this.maxAge;
        }

        public boolean canGrow(BlockGetter level, BlockPos pos, BlockState state, int maxHeight) {
            if (state.m_60734_() != this.block) {
                return false;
            }
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            if (stateAbove.m_60795_()) {
                int n = LevelUtil.getNumOfBlocksBelow(level, pos, this.block, maxHeight);
                return n + 1 < maxHeight && this.isNotFullyGrown(level.m_8055_(pos));
            }
            if (stateAbove.m_60734_() == this.block) {
                int nDown;
                int nUp = LevelUtil.getNumOfBlocksAbove(level, pos, this.block, maxHeight);
                return nUp + (nDown = LevelUtil.getNumOfBlocksBelow(level, pos, this.block, maxHeight)) + 1 < maxHeight && this.isNotFullyGrown(level.m_8055_(pos.m_6630_(nUp)));
            }
            return false;
        }

        public void grow(ServerLevel level, BlockPos pos, BlockState state, int maxHeight, int ageModifier) {
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            if (stateAbove.m_60795_()) {
                this.grow(level, pos, state, ageModifier);
            } else {
                int nUp = LevelUtil.getNumOfBlocksAbove((BlockGetter)level, pos, this.block, maxHeight);
                BlockPos posTop = pos.m_6630_(nUp);
                this.grow(level, posTop, level.m_8055_(posTop), ageModifier);
            }
        }

        private void grow(ServerLevel level, BlockPos pos, BlockState state, int ageModifier) {
            int age = Math.min(this.maxAge, (Integer)state.m_61143_((Property)this.ageProperty) + ageModifier);
            if (age == this.maxAge) {
                BlockPos posAbove = pos.m_7494_();
                level.m_46597_(posAbove, this.block.m_49966_());
                BlockState newState = (BlockState)state.m_61124_((Property)this.ageProperty, (Comparable)Integer.valueOf(0));
                level.m_7731_(pos, newState, 4);
                if (this.callNeighborChanged) {
                    newState.m_60690_((Level)level, posAbove, this.block, pos, false);
                }
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.ageProperty, (Comparable)Integer.valueOf(age)), 4);
            }
        }
    }
}

