/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.util.ComponentUtil;
import com.ibm.icu.text.Transliterator;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TransliterationUtil {
    private static final String ANY_TO_LATIN_WITHOUT_ACCENTS_TO_ASCII = "Any-Latin; NFD; [:Nonspacing Mark:] Remove; NFC; Latin-ASCII;";
    private static Transliterator ASCII_TRANSLITERATOR;

    private TransliterationUtil() {
    }

    public static void init() {
        ASCII_TRANSLITERATOR = Transliterator.getInstance((String)ANY_TO_LATIN_WITHOUT_ACCENTS_TO_ASCII);
    }

    public static String transliterate(String text) {
        if (text.isBlank()) {
            return text;
        }
        return ASCII_TRANSLITERATOR.transliterate(text);
    }

    public static Component transliterate(Component component, UnaryOperator<String> resultModifier) {
        String original = component.getString();
        String transliterated = TransliterationUtil.transliterate(original);
        if (transliterated.equals(original)) {
            return component;
        }
        return ComponentUtil.literal((String)resultModifier.apply(transliterated)).m_6270_(component.m_7383_());
    }
}

