/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.colors;

public final class ColorHarmony {
    private ColorHarmony() {
    }

    private static double adjustHue(double hue, double angleDegrees) {
        return hue + angleDegrees;
    }

    public static double[][] analogousOkLCh(double[] okLCh) {
        double lightness = okLCh[0];
        double chroma = okLCh[1];
        double hue = okLCh[2];
        double[] colorA = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, 30.0)};
        double[] colorB = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, -30.0)};
        return new double[][]{okLCh, colorA, colorB};
    }

    public static double[][] complementaryOkLCh(double[] okLCh) {
        return ColorHarmony.geometricOkLCh(okLCh, 2);
    }

    public static double[][] splitComplementaryOkLCh(double[] okLCh) {
        double lightness = okLCh[0];
        double chroma = okLCh[1];
        double hue = okLCh[2];
        double[] colorA = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, 210.0)};
        double[] colorB = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, -210.0)};
        return new double[][]{okLCh, colorA, colorB};
    }

    public static double[][] triadicOkLCh(double[] okLCh) {
        return ColorHarmony.geometricOkLCh(okLCh, 3);
    }

    public static double[][] tetradicSquareOkLCh(double[] okLCh) {
        return ColorHarmony.geometricOkLCh(okLCh, 4);
    }

    public static double[][] tetradicRectOkLCh(double[] okLCh) {
        double lightness = okLCh[0];
        double chroma = okLCh[1];
        double hue = okLCh[2];
        double[] colorA = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, 30.0)};
        double[] colorB = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, 180.0)};
        double[] colorC = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, 210.0)};
        return new double[][]{okLCh, colorA, colorB, colorC};
    }

    public static double[][] wheelOkLCh(double[] okLCh) {
        return ColorHarmony.geometricOkLCh(okLCh, 12);
    }

    public static double[][] geometricOkLCh(double[] okLCh, int count) {
        double stepSize;
        double lightness = okLCh[0];
        double chroma = okLCh[1];
        double hue = okLCh[2];
        double[][] colors = new double[count][3];
        colors[0] = okLCh;
        double angleDegrees = stepSize = 360.0 / (double)count;
        for (int i = 1; i < count; ++i) {
            colors[i] = new double[]{lightness, chroma, ColorHarmony.adjustHue(hue, angleDegrees)};
            angleDegrees += stepSize;
        }
        return colors;
    }
}

