/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound;

import com.github.elenterius.biomancy.world.mound.MoundChamber;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberDecorators;
import com.github.elenterius.biomancy.world.spatial.geometry.OctantEllipsoidShape;
import com.github.elenterius.biomancy.world.spatial.geometry.SphereShape;
import java.util.function.Consumer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;

public interface ChamberFactory {
    public static final ChamberFactory ONE_SPHERE = (x, y, z, chamberRadius, random, consumer) -> consumer.accept(new MoundChamber(new SphereShape(x, y, z, chamberRadius)));
    public static final ChamberFactory EIGHT_SMALL_ELLIPSOIDS = (x, y, z, chamberRadius, random, consumer) -> {
        float halfR = chamberRadius / 2.0f;
        float quarterR = halfR / 2.0f;
        float p = chamberRadius / 3.8f;
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y + (double)p, z + (double)p, halfR, halfR, halfR, quarterR, quarterR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y + (double)p, z + (double)p, quarterR, halfR, halfR, halfR, quarterR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y + (double)p, z - (double)p, halfR, halfR, quarterR, quarterR, quarterR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y + (double)p, z - (double)p, quarterR, halfR, quarterR, halfR, quarterR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y - (double)p, z + (double)p, halfR, quarterR, halfR, quarterR, halfR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y - (double)p, z + (double)p, quarterR, quarterR, halfR, halfR, halfR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y - (double)p, z - (double)p, halfR, quarterR, quarterR, quarterR, halfR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y - (double)p, z - (double)p, quarterR, quarterR, quarterR, halfR, halfR, halfR)));
    };
    public static final ChamberFactory ONE_BIG_FOUR_SMALL_ELLIPSOIDS = (x, y, z, chamberRadius, random, consumer) -> {
        float halfR = chamberRadius / 2.0f;
        float quarterR = halfR / 2.0f;
        float p = chamberRadius / 3.8f;
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x, y + (double)p, z, halfR, halfR, halfR, halfR, quarterR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y - (double)p, z + (double)p, halfR, quarterR, halfR, quarterR, halfR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y - (double)p, z + (double)p, quarterR, quarterR, halfR, halfR, halfR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y - (double)p, z - (double)p, halfR, quarterR, quarterR, quarterR, halfR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y - (double)p, z - (double)p, quarterR, quarterR, quarterR, halfR, halfR, halfR)));
    };
    public static final ChamberFactory FOUR_SMALL_ONE_BIG_ELLIPSOIDS = (x, y, z, chamberRadius, random, consumer) -> {
        float halfR = chamberRadius / 2.0f;
        float quarterR = halfR / 2.0f;
        float p = chamberRadius / 3.8f;
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y + (double)p, z + (double)p, halfR, halfR, halfR, quarterR, quarterR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y + (double)p, z + (double)p, quarterR, halfR, halfR, halfR, quarterR, quarterR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y + (double)p, z - (double)p, halfR, halfR, quarterR, quarterR, quarterR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y + (double)p, z - (double)p, quarterR, halfR, quarterR, halfR, quarterR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x, y - (double)p, z, halfR, quarterR, halfR, halfR, halfR, halfR)));
    };
    public static final ChamberFactory TWO_BIG_ELLIPSOIDS = (x, y, z, chamberRadius, random, consumer) -> {
        float halfR = chamberRadius / 2.0f;
        float quarterR = halfR / 2.0f;
        float p = chamberRadius / 3.8f;
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x, y + (double)p, z, halfR, halfR, halfR, halfR, quarterR, halfR)));
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x, y - (double)p, z, halfR, quarterR, halfR, halfR, halfR, halfR)));
    };
    public static final ChamberFactory SPECIAL_CRADLE = (x, y, z, chamberRadius, random, consumer) -> {
        float halfR = chamberRadius / 2.0f;
        float quarterR = halfR / 2.0f;
        float p = chamberRadius / 3.8f;
        consumer.accept(new MoundChamber(new OctantEllipsoidShape(x, y + (double)p - 1.0, z, halfR, halfR, halfR, halfR, quarterR, halfR)));
        Consumer<MoundChamber> wrappedConsumer = chamber -> {
            chamber.setDecorator(ChamberDecorators.PRIMAL_ORIFICE_COMBS, random.m_188502_());
            consumer.accept(chamber);
        };
        float offset = 0.5f;
        wrappedConsumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y - (double)p - (double)offset, z + (double)p, halfR, quarterR, halfR, quarterR, halfR, quarterR)));
        wrappedConsumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y - (double)p - (double)offset, z + (double)p, quarterR, quarterR, halfR, halfR, halfR, quarterR)));
        wrappedConsumer.accept(new MoundChamber(new OctantEllipsoidShape(x + (double)p, y - (double)p - (double)offset, z - (double)p, halfR, quarterR, quarterR, quarterR, halfR, halfR)));
        wrappedConsumer.accept(new MoundChamber(new OctantEllipsoidShape(x - (double)p, y - (double)p - (double)offset, z - (double)p, quarterR, quarterR, quarterR, halfR, halfR, halfR)));
    };
    public static final SimpleWeightedRandomList<ChamberFactory> RANDOM_DEFAULTS_LIST = SimpleWeightedRandomList.m_146263_().m_146271_((Object)ONE_SPHERE, 5).m_146271_((Object)ONE_BIG_FOUR_SMALL_ELLIPSOIDS, 20).m_146271_((Object)FOUR_SMALL_ONE_BIG_ELLIPSOIDS, 20).m_146271_((Object)TWO_BIG_ELLIPSOIDS, 10).m_146271_((Object)EIGHT_SMALL_ELLIPSOIDS, 60).m_146270_();
    public static final ChamberFactory RANDOM_DEFAULT = (x, y, z, chamberRadius, random, consumer) -> {
        ChamberFactory factory = RANDOM_DEFAULTS_LIST.m_216820_(random).orElse(EIGHT_SMALL_ELLIPSOIDS);
        Consumer<MoundChamber> wrappedConsumer = chamber -> {
            chamber.setDecorator(ChamberDecorators.getRandomDefault(random), random.m_188502_());
            consumer.accept(chamber);
        };
        factory.create(x, y, z, chamberRadius, random, wrappedConsumer);
    };

    public void create(double var1, double var3, double var5, float var7, RandomSource var8, Consumer<MoundChamber> var9);
}

